/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.mkdir;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.extensions.common.AeshTestCommons;
import org.aesh.extensions.ls.Ls;
import org.aesh.extensions.mkdir.Mkdir;
import org.aesh.terminal.utils.Config;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MkdirTest
extends AeshTestCommons {
    private Path tempDir;
    private String aeshRocksDir;
    private String aeshRocksSubDir;

    @Before
    public void before() throws IOException {
        this.tempDir = this.createTempDirectory();
        this.aeshRocksDir = this.tempDir.toFile().getAbsolutePath() + Config.getPathSeparator() + "aesh_rocks";
        this.aeshRocksSubDir = this.tempDir.toFile().getAbsolutePath() + Config.getPathSeparator() + "aesh_rocks" + Config.getPathSeparator() + "subdir1" + Config.getPathSeparator() + "subdir2";
    }

    @Test
    public void testMkdir() throws IOException, CommandRegistryException {
        this.prepare(Mkdir.class, Ls.class);
        Assert.assertFalse((boolean)new File(this.aeshRocksDir).exists());
        this.pushToOutput("mkdir -v " + this.aeshRocksDir);
        Assert.assertTrue((boolean)new File(this.aeshRocksDir).exists());
        Assert.assertFalse((boolean)new File(this.aeshRocksSubDir).exists());
        this.pushToOutput("mkdir -p " + this.aeshRocksSubDir);
        Assert.assertTrue((boolean)new File(this.aeshRocksSubDir).exists());
        this.finish();
    }

    @After
    public void after() {
        try {
            Files.delete(new File(this.aeshRocksSubDir).toPath());
            Files.delete(new File(this.aeshRocksDir + Config.getPathSeparator() + "subdir1").toPath());
            Files.delete(new File(this.aeshRocksDir).toPath());
            Files.delete(this.tempDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

