/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.rm;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.extensions.cat.Cat;
import org.aesh.extensions.cd.Cd;
import org.aesh.extensions.common.AeshTestCommons;
import org.aesh.extensions.ls.Ls;
import org.aesh.extensions.mkdir.Mkdir;
import org.aesh.extensions.rm.Rm;
import org.aesh.extensions.touch.Touch;
import org.aesh.readline.terminal.Key;
import org.aesh.terminal.utils.Config;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class RmTest
extends AeshTestCommons {
    private Path tempDir;

    @Before
    public void before() throws IOException {
        this.tempDir = this.createTempDirectory();
    }

    @After
    public void after() throws IOException {
        this.deleteRecursiveTempDirectory(this.tempDir);
    }

    @Test
    public void testRm() throws IOException, CommandRegistryException {
        this.prepare(Touch.class, Mkdir.class, Cd.class, Cat.class, Ls.class, Rm.class);
        String tempPath = this.tempDir.toFile().getAbsolutePath() + Config.getPathSeparator();
        this.pushToOutput("touch " + tempPath + "file01.txt");
        Assert.assertTrue((boolean)new File(tempPath + "file01.txt").exists());
        this.pushToOutput("rm " + tempPath + "file01.txt");
        Assert.assertFalse((boolean)new File(tempPath + "file01.txt").exists());
        this.pushToOutput("cd " + tempPath);
        this.pushToOutput("mkdir " + tempPath + "aesh_rocks");
        Assert.assertTrue((boolean)new File(tempPath + "aesh_rocks").exists());
        this.pushToOutput("rm -d " + tempPath + "aesh_rocks");
        Assert.assertFalse((boolean)new File(tempPath + "aesh_rocks").exists());
        this.pushToOutput("touch " + tempPath + "file03.txt");
        Assert.assertTrue((boolean)new File(tempPath + "file03.txt").exists());
        this.pushToOutput("rm -i " + tempPath + "file03.txt");
        this.pushToOutput("y");
        Assert.assertFalse((boolean)new File(tempPath + "file03.txt").exists());
        this.pushToOutput("cd " + tempPath);
        this.pushToOutput("mkdir " + tempPath + "aesh_rocks2");
        Assert.assertTrue((boolean)new File(tempPath + "aesh_rocks2").exists());
        this.pushToOutput("rm -di " + tempPath + "aesh_rocks2");
        this.pushToOutput("y");
        Assert.assertFalse((boolean)new File(tempPath + "aesh_rocks2").exists());
        this.connection().clearOutputBuffer();
        this.pushToOutput("touch " + tempPath + "file04.txt");
        this.output("rm " + tempPath + "file04.txt");
        this.output(String.valueOf(Key.CTRL_C));
        this.pushToOutput("cat " + tempPath + "file04.txt");
        Assert.assertFalse((boolean)this.connection().getOutputBuffer().contains("No such file or directory"));
        this.finish();
    }
}

