/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.touch;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.extensions.common.AeshTestCommons;
import org.aesh.extensions.ls.Ls;
import org.aesh.extensions.touch.Touch;
import org.aesh.terminal.utils.Config;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TouchTest
extends AeshTestCommons {
    private Path tempDir;

    @Before
    public void before() throws IOException {
        this.tempDir = this.createTempDirectory();
    }

    @After
    public void after() throws IOException {
        this.deleteRecursiveTempDirectory(this.tempDir);
    }

    @Test
    public void testTouch() throws IOException, CommandRegistryException {
        this.prepare(Touch.class, Ls.class);
        String tempPath = this.tempDir.toFile().getAbsolutePath() + Config.getPathSeparator();
        this.pushToOutput("touch " + tempPath + "file01.txt");
        Assert.assertTrue((boolean)new File(tempPath + "file01.txt").exists());
        this.pushToOutput("touch -a " + tempPath + "file01.txt");
        Assert.assertTrue((boolean)new File(tempPath + "file01.txt").exists());
        this.pushToOutput("touch -c " + tempPath + "file02.txt");
        Assert.assertFalse((boolean)new File(tempPath + "file02.txt").exists());
        this.pushToOutput("touch -m " + tempPath + "file02.txt");
        Assert.assertTrue((boolean)new File(tempPath + "file02.txt").exists());
    }
}

