/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.action.mappings;

import java.util.Arrays;
import org.aesh.parser.LineParser;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.action.mappings.MovementAction;
import org.aesh.readline.editing.EditMode;

abstract class ChangeAction
extends MovementAction {
    private EditMode.Status status;
    protected boolean viMode;

    ChangeAction(EditMode.Status status) {
        this.status = status;
        this.viMode = false;
    }

    ChangeAction(boolean viMode, EditMode.Status status) {
        this.status = status;
        this.viMode = viMode;
    }

    protected EditMode.Status getStatus() {
        return this.status;
    }

    protected final void apply(int cursor, InputProcessor inputProcessor) {
        this.apply(cursor, inputProcessor.getBuffer().buffer().cursor(), inputProcessor);
    }

    protected final void apply(int cursor, int oldCursor, InputProcessor inputProcessor) {
        String word;
        if (this.status == EditMode.Status.DELETE || this.status == EditMode.Status.CHANGE) {
            inputProcessor.getBuffer().addActionToUndoStack();
            if (cursor < oldCursor) {
                inputProcessor.getBuffer().pasteManager().addText(Arrays.copyOfRange(inputProcessor.getBuffer().buffer().multiLine(), cursor, oldCursor));
                inputProcessor.getBuffer().delete(cursor - oldCursor);
            } else {
                inputProcessor.getBuffer().pasteManager().addText(Arrays.copyOfRange(inputProcessor.getBuffer().buffer().multiLine(), oldCursor, cursor));
                inputProcessor.getBuffer().delete(cursor - oldCursor);
            }
            if (this.viMode && this.status == EditMode.Status.DELETE && oldCursor == inputProcessor.getBuffer().buffer().length()) {
                inputProcessor.getBuffer().moveCursor(-1);
            }
        } else if (this.status == EditMode.Status.MOVE) {
            inputProcessor.getBuffer().moveCursor(cursor - oldCursor);
        } else if (this.status == EditMode.Status.YANK) {
            if (cursor < oldCursor) {
                inputProcessor.getBuffer().pasteManager().addText(Arrays.copyOfRange(inputProcessor.getBuffer().buffer().multiLine(), cursor, oldCursor));
            } else if (cursor > oldCursor) {
                inputProcessor.getBuffer().pasteManager().addText(Arrays.copyOfRange(inputProcessor.getBuffer().buffer().multiLine(), oldCursor, cursor));
            }
        } else if (this.status == EditMode.Status.UP_CASE) {
            if (cursor < oldCursor) {
                inputProcessor.getBuffer().addActionToUndoStack();
                for (int i = cursor; i < oldCursor; ++i) {
                    inputProcessor.getBuffer().upCase();
                }
            } else {
                inputProcessor.getBuffer().addActionToUndoStack();
                for (int i = oldCursor; i < cursor; ++i) {
                    inputProcessor.getBuffer().upCase();
                }
            }
            inputProcessor.getBuffer().moveCursor(cursor - oldCursor);
        } else if (this.status == EditMode.Status.DOWN_CASE) {
            if (cursor < oldCursor) {
                inputProcessor.getBuffer().addActionToUndoStack();
                for (int i = cursor; i < oldCursor; ++i) {
                    inputProcessor.getBuffer().downCase();
                }
            } else {
                inputProcessor.getBuffer().addActionToUndoStack();
                for (int i = oldCursor; i < cursor; ++i) {
                    inputProcessor.getBuffer().downCase();
                }
            }
            inputProcessor.getBuffer().moveCursor(cursor - oldCursor);
        } else if (this.status == EditMode.Status.CAPITALIZE && (word = LineParser.parseLine(inputProcessor.getBuffer().buffer().asString(), oldCursor).selectedWord().word()).length() > 0) {
            inputProcessor.getBuffer().addActionToUndoStack();
            int pos = inputProcessor.getBuffer().buffer().asString().indexOf(word, oldCursor - word.length());
            if (pos < 0) {
                pos = 0;
            }
            inputProcessor.getBuffer().upCase();
            inputProcessor.getBuffer().moveCursor(cursor - oldCursor);
        }
    }
}

