/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.alias;

import org.aesh.parser.LineParser;
import org.aesh.readline.alias.AliasManager;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.completion.Completion;

public class AliasCompletion
implements Completion {
    private static final String ALIAS = "alias";
    private static final String ALIAS_SPACE = "alias ";
    private static final String UNALIAS = "unalias";
    private static final String UNALIAS_SPACE = "unalias ";
    private static final String HELP = "--help";
    private final AliasManager manager;

    public AliasCompletion(AliasManager manager) {
        this.manager = manager;
    }

    public void complete(CompleteOperation completeOperation) {
        completeOperation.addCompletionCandidates(this.manager.findAllMatchingNames(completeOperation.getBuffer()));
        if (completeOperation.getBuffer() == null || completeOperation.getBuffer().length() < 1) {
            completeOperation.addCompletionCandidate(ALIAS);
            completeOperation.addCompletionCandidate(UNALIAS);
        } else if (ALIAS.startsWith(completeOperation.getBuffer())) {
            completeOperation.addCompletionCandidate(ALIAS);
        } else if (UNALIAS.startsWith(completeOperation.getBuffer())) {
            completeOperation.addCompletionCandidate(UNALIAS);
        } else if (completeOperation.getBuffer().equals(ALIAS_SPACE) || completeOperation.getBuffer().equals(UNALIAS_SPACE)) {
            completeOperation.addCompletionCandidates(this.manager.getAllNames());
            completeOperation.addCompletionCandidate(HELP);
            completeOperation.setOffset(completeOperation.getCursor());
        } else if (completeOperation.getBuffer().startsWith(ALIAS_SPACE) || completeOperation.getBuffer().startsWith(UNALIAS_SPACE)) {
            String word = LineParser.parseLine(completeOperation.getBuffer(), completeOperation.getCursor()).selectedWordToCursor().word();
            completeOperation.addCompletionCandidates(this.manager.findAllMatchingNames(word));
            if (!word.isEmpty() && HELP.startsWith(word)) {
                completeOperation.addCompletionCandidate(HELP);
            }
            completeOperation.setOffset(completeOperation.getCursor() - word.length());
        }
    }
}

