/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.ArrayList;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.tty.terminal.TestConnection;
import org.aesh.util.Config;
import org.junit.Test;

public class CompletionReadlineTest {
    @Test
    public void testCompletion() {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        completions.add(co -> {
            if (co.getBuffer().equals("foo")) {
                co.addCompletionCandidate("foobar");
            }
        });
        completions.add(co -> {
            if (co.getBuffer().equals("bar")) {
                co.addCompletionCandidate("barfoo");
                co.doAppendSeparator(false);
            }
        });
        completions.add(co -> {
            if (co.getBuffer().equals("le")) {
                co.addCompletionCandidate("less");
                co.setSeparator(':');
            }
        });
        TestConnection term = new TestConnection(completions);
        term.read("foo".getBytes());
        term.read(Key.CTRL_I);
        term.read(Config.getLineSeparator());
        term.assertLine("foobar ");
        term.readline(completions);
        term.read("bar".getBytes());
        term.read(Key.CTRL_I);
        term.read(Config.getLineSeparator());
        term.assertLine("barfoo");
        term.readline(completions);
        term.read("le".getBytes());
        term.read(Key.CTRL_I);
        term.read(Config.getLineSeparator());
        term.assertLine("less:");
    }
}

