/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.editing;

import org.aesh.readline.terminal.Key;
import org.aesh.readline.tty.terminal.TestConnection;
import org.junit.Test;

public class EmacsModeTest {
    @Test
    public void testSimpleMovementAndEdit() {
        TestConnection term = new TestConnection();
        term.read("1234");
        term.read(Key.CTRL_D);
        term.assertBuffer("1234");
        term.read(Key.LEFT);
        term.read(Key.CTRL_D);
        term.read(53);
        term.assertBuffer("1235");
        term.read(Key.CTRL_A);
        term.read(Key.CTRL_D);
        term.assertBuffer("235");
        term.read(Key.CTRL_F);
        term.read(Key.CTRL_F);
        term.read(54);
        term.assertBuffer("2365");
    }

    @Test
    public void testWordMovementAndEdit() throws Exception {
        TestConnection term = new TestConnection();
        term.read("foo  bar...  Foo-Bar.");
        term.read(Key.META_b);
        term.read(Key.META_d);
        term.assertBuffer("foo  bar...  Foo-.");
        term.read(Key.CTRL_E);
        term.read(Key.LEFT);
        term.read("Bar");
        term.assertBuffer("foo  bar...  Foo-Bar.");
        term.read(Key.CTRL_A);
        term.read(Key.META_f);
        term.read(Key.META_f);
        term.read(Key.META_d);
        term.assertBuffer("foo  bar-Bar.");
        term.read(Key.META_b);
        term.read(Key.CTRL_U);
        term.assertBuffer("bar-Bar.");
    }

    @Test
    public void testSwitchingEditModes() throws Exception {
        TestConnection term = new TestConnection();
        term.read("foo  bar...  Foo-Bar.");
        term.read(Key.CTRL_A);
        term.read("A ");
        term.assertBuffer("A foo  bar...  Foo-Bar.");
        term.read(Key.CTRL_E);
        term.read(".");
        term.assertBuffer("A foo  bar...  Foo-Bar..");
        term.read(Key.META_CTRL_J);
        term.read(Key.ESC);
        term.read(Key.ZERO);
        term.read(Key.i);
        term.read("A ");
        term.assertBuffer("A A foo  bar...  Foo-Bar..");
        term.read(Key.ESC);
        term.read(Key.CTRL_E);
        term.read(Key.CTRL_E);
        term.read(".");
        term.assertBuffer("A A foo  bar...  Foo-Bar...");
    }
}

