/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal;

import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;

public interface Connection {
    public String terminalType();

    public Size size();

    public Consumer<Size> getSizeHandler();

    public void setSizeHandler(Consumer<Size> var1);

    public Consumer<Signal> getSignalHandler();

    public void setSignalHandler(Consumer<Signal> var1);

    public Consumer<int[]> getStdinHandler();

    public void setStdinHandler(Consumer<int[]> var1);

    public Consumer<int[]> stdoutHandler();

    public void setCloseHandler(Consumer<Void> var1);

    public Consumer<Void> getCloseHandler();

    public void close();

    public void openBlocking();

    public void openNonBlocking();

    public boolean put(Capability var1, Object ... var2);

    public Charset inputCharset();

    public Charset outputCharset();

    default public Connection write(String s) {
        int[] codePoints = s.codePoints().toArray();
        this.stdoutHandler().accept(codePoints);
        return this;
    }
}

