/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.aesh.readline.Buffer;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.action.mappings.ActionMapper;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.completion.CompleteOperationImpl;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.completion.CompletionHandler;
import org.aesh.terminal.formatting.TerminalString;
import org.aesh.util.Config;
import org.aesh.util.Parser;

public class SimpleCompletionHandler
implements CompletionHandler<CompleteOperation> {
    private CompletionHandler.CompletionStatus status = CompletionHandler.CompletionStatus.COMPLETE;
    private int displayCompletionSize = 100;
    private final List<Completion> completionList = new ArrayList<Completion>();
    private Function<Buffer, CompleteOperation> aliasHandler;

    @Override
    public void addCompletion(Completion completion) {
        this.completionList.add(completion);
    }

    @Override
    public void removeCompletion(Completion completion) {
        this.completionList.remove(completion);
    }

    @Override
    public void clear() {
        this.completionList.clear();
    }

    @Override
    public CompletionHandler.CompletionStatus completionStatus() {
        return this.status;
    }

    @Override
    public void setCompletionStatus(CompletionHandler.CompletionStatus status) {
        this.status = status;
    }

    @Override
    public void setAskCompletionSize(int size) {
        this.displayCompletionSize = size;
    }

    @Override
    public int getAskCompletionSize() {
        return this.displayCompletionSize;
    }

    @Override
    public void setAliasHandler(Function<Buffer, CompleteOperation> aliasHandler) {
        this.aliasHandler = aliasHandler;
    }

    @Override
    public void addCompletions(List<Completion> completions) {
        if (completions != null && completions.size() > 0) {
            this.completionList.addAll(completions);
        }
    }

    @Override
    public void complete(InputProcessor inputProcessor) {
        if (this.completionList.size() == 0) {
            return;
        }
        Buffer buffer = inputProcessor.getBuffer().getBuffer();
        if (this.completionList.size() < 1) {
            return;
        }
        ArrayList<CompleteOperation> possibleCompletions = new ArrayList<CompleteOperation>();
        for (int i = 0; i < this.completionList.size(); ++i) {
            CompleteOperation co = this.aliasHandler == null ? new CompleteOperationImpl(buffer.asString(), buffer.getCursor()) : this.aliasHandler.apply(buffer);
            this.completionList.get(i).complete(co);
            if (co.getCompletionCandidates() == null || co.getCompletionCandidates().size() <= 0) continue;
            possibleCompletions.add(co);
        }
        if (possibleCompletions.size() != 0) {
            if (possibleCompletions.size() == 1 && ((CompleteOperation)possibleCompletions.get(0)).getCompletionCandidates().size() == 1) {
                this.displayCompletion(((CompleteOperation)possibleCompletions.get(0)).getFormattedCompletionCandidatesTerminalString().get(0), buffer, inputProcessor, ((CompleteOperation)possibleCompletions.get(0)).hasAppendSeparator(), ((CompleteOperation)possibleCompletions.get(0)).getSeparator());
            } else {
                String startsWith = "";
                if (!((CompleteOperation)possibleCompletions.get(0)).isIgnoreStartsWith()) {
                    startsWith = Parser.findStartsWithOperation(possibleCompletions);
                }
                if (startsWith.length() > 0) {
                    if (startsWith.contains(" ") && !((CompleteOperation)possibleCompletions.get(0)).doIgnoreNonEscapedSpace()) {
                        this.displayCompletion(new TerminalString(Parser.switchSpacesToEscapedSpacesInWord(startsWith), true), buffer, inputProcessor, false, ((CompleteOperation)possibleCompletions.get(0)).getSeparator());
                    } else {
                        this.displayCompletion(new TerminalString(startsWith, true), buffer, inputProcessor, false, ((CompleteOperation)possibleCompletions.get(0)).getSeparator());
                    }
                } else {
                    ArrayList<TerminalString> completions = new ArrayList<TerminalString>();
                    for (int i = 0; i < possibleCompletions.size(); ++i) {
                        completions.addAll(((CompleteOperation)possibleCompletions.get(i)).getCompletionCandidates());
                    }
                    if (completions.size() > 100) {
                        if (this.status == CompletionHandler.CompletionStatus.ASKING_FOR_COMPLETIONS) {
                            this.displayCompletions(completions, buffer, inputProcessor);
                            this.status = CompletionHandler.CompletionStatus.COMPLETE;
                        } else {
                            this.status = CompletionHandler.CompletionStatus.ASKING_FOR_COMPLETIONS;
                            inputProcessor.getBuffer().writeOut(Config.CR);
                            inputProcessor.getBuffer().writeOut("Display all " + completions.size() + " possibilities? (y or n)");
                        }
                    } else {
                        this.displayCompletions(completions, buffer, inputProcessor);
                    }
                }
            }
        }
    }

    private void displayCompletion(TerminalString completion, Buffer buffer, InputProcessor inputProcessor, boolean appendSpace, char separator) {
        if (completion.getCharacters().startsWith(buffer.asString())) {
            ActionMapper.mapToAction("backward-kill-word").accept(inputProcessor);
            inputProcessor.getBuffer().writeString(completion.toString());
        } else {
            inputProcessor.getBuffer().writeString(completion.toString());
        }
        if (appendSpace) {
            inputProcessor.getBuffer().writeChar(separator);
        }
    }

    private void displayCompletions(List<TerminalString> completions, Buffer buffer, InputProcessor inputProcessor) {
        Collections.sort(completions);
        inputProcessor.getBuffer().writeOut(Config.CR);
        inputProcessor.getBuffer().writeOut(Parser.formatDisplayListTerminalString(completions, inputProcessor.getBuffer().getSize().getHeight(), inputProcessor.getBuffer().getSize().getWidth()));
        buffer.setIsPromptDisplayed(false);
        inputProcessor.getBuffer().drawLine();
    }
}

