/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal;

import java.nio.IntBuffer;
import org.aesh.readline.action.KeyAction;
import org.aesh.terminal.utils.InfoCmpHelper;
import org.aesh.util.Config;
import org.aesh.util.Parser;

public final class Key
extends Enum<Key>
implements KeyAction {
    public static final /* enum */ Key CTRL_AT;
    public static final /* enum */ Key CTRL_A;
    public static final /* enum */ Key CTRL_B;
    public static final /* enum */ Key CTRL_C;
    public static final /* enum */ Key CTRL_D;
    public static final /* enum */ Key CTRL_E;
    public static final /* enum */ Key CTRL_F;
    public static final /* enum */ Key CTRL_G;
    public static final /* enum */ Key CTRL_H;
    public static final /* enum */ Key CTRL_I;
    public static final /* enum */ Key CTRL_J;
    public static final /* enum */ Key CTRL_K;
    public static final /* enum */ Key CTRL_L;
    public static final /* enum */ Key CTRL_M;
    public static final /* enum */ Key CTRL_N;
    public static final /* enum */ Key CTRL_O;
    public static final /* enum */ Key CTRL_P;
    public static final /* enum */ Key CTRL_Q;
    public static final /* enum */ Key CTRL_R;
    public static final /* enum */ Key CTRL_S;
    public static final /* enum */ Key CTRL_T;
    public static final /* enum */ Key CTRL_U;
    public static final /* enum */ Key CTRL_V;
    public static final /* enum */ Key CTRL_W;
    public static final /* enum */ Key CTRL_X;
    public static final /* enum */ Key CTRL_Y;
    public static final /* enum */ Key CTRL_Z;
    public static final /* enum */ Key ESC;
    public static final /* enum */ Key FILE_SEPARATOR;
    public static final /* enum */ Key GROUP_SEPARATOR;
    public static final /* enum */ Key RECORD_SEPARATOR;
    public static final /* enum */ Key UNIT_SEPARATOR;
    public static final /* enum */ Key SPACE;
    public static final /* enum */ Key EXCLAMATION;
    public static final /* enum */ Key QUOTE;
    public static final /* enum */ Key HASH;
    public static final /* enum */ Key DOLLAR;
    public static final /* enum */ Key PERCENT;
    public static final /* enum */ Key AMPERSAND;
    public static final /* enum */ Key APOSTROPHE;
    public static final /* enum */ Key LEFT_PARANTHESIS;
    public static final /* enum */ Key RIGHT_PARANTHESIS;
    public static final /* enum */ Key STAR;
    public static final /* enum */ Key PLUS;
    public static final /* enum */ Key COMMA;
    public static final /* enum */ Key MINUS;
    public static final /* enum */ Key PERIOD;
    public static final /* enum */ Key SLASH;
    public static final /* enum */ Key ZERO;
    public static final /* enum */ Key ONE;
    public static final /* enum */ Key TWO;
    public static final /* enum */ Key THREE;
    public static final /* enum */ Key FOUR;
    public static final /* enum */ Key FIVE;
    public static final /* enum */ Key SIX;
    public static final /* enum */ Key SEVEN;
    public static final /* enum */ Key EIGHT;
    public static final /* enum */ Key NINE;
    public static final /* enum */ Key COLON;
    public static final /* enum */ Key SEMI_COLON;
    public static final /* enum */ Key LESS_THAN;
    public static final /* enum */ Key EQUALS;
    public static final /* enum */ Key GREATER_THAN;
    public static final /* enum */ Key QUESTION_MARK;
    public static final /* enum */ Key AT;
    public static final /* enum */ Key A;
    public static final /* enum */ Key B;
    public static final /* enum */ Key C;
    public static final /* enum */ Key D;
    public static final /* enum */ Key E;
    public static final /* enum */ Key F;
    public static final /* enum */ Key G;
    public static final /* enum */ Key H;
    public static final /* enum */ Key I;
    public static final /* enum */ Key J;
    public static final /* enum */ Key K;
    public static final /* enum */ Key L;
    public static final /* enum */ Key M;
    public static final /* enum */ Key N;
    public static final /* enum */ Key O;
    public static final /* enum */ Key P;
    public static final /* enum */ Key Q;
    public static final /* enum */ Key R;
    public static final /* enum */ Key S;
    public static final /* enum */ Key T;
    public static final /* enum */ Key U;
    public static final /* enum */ Key V;
    public static final /* enum */ Key W;
    public static final /* enum */ Key X;
    public static final /* enum */ Key Y;
    public static final /* enum */ Key Z;
    public static final /* enum */ Key LEFT_SQUARE_BRACKET;
    public static final /* enum */ Key BACKSLASH;
    public static final /* enum */ Key RIGHT_SQUARE_BRACKET;
    public static final /* enum */ Key HAT;
    public static final /* enum */ Key UNDERSCORE;
    public static final /* enum */ Key GRAVE;
    public static final /* enum */ Key a;
    public static final /* enum */ Key b;
    public static final /* enum */ Key c;
    public static final /* enum */ Key d;
    public static final /* enum */ Key e;
    public static final /* enum */ Key f;
    public static final /* enum */ Key g;
    public static final /* enum */ Key h;
    public static final /* enum */ Key i;
    public static final /* enum */ Key j;
    public static final /* enum */ Key k;
    public static final /* enum */ Key l;
    public static final /* enum */ Key m;
    public static final /* enum */ Key n;
    public static final /* enum */ Key o;
    public static final /* enum */ Key p;
    public static final /* enum */ Key q;
    public static final /* enum */ Key r;
    public static final /* enum */ Key s;
    public static final /* enum */ Key t;
    public static final /* enum */ Key u;
    public static final /* enum */ Key v;
    public static final /* enum */ Key w;
    public static final /* enum */ Key x;
    public static final /* enum */ Key y;
    public static final /* enum */ Key z;
    public static final /* enum */ Key LEFT_CURLY_BRACKET;
    public static final /* enum */ Key VERTICAL_BAR;
    public static final /* enum */ Key RIGHT_CURLY_BRACKET;
    public static final /* enum */ Key TILDE;
    public static final /* enum */ Key BACKSPACE;
    public static final /* enum */ Key WINDOWS_ESC;
    public static final /* enum */ Key WINDOWS_ESC_2;
    public static final /* enum */ Key UP;
    public static final /* enum */ Key DOWN;
    public static final /* enum */ Key RIGHT;
    public static final /* enum */ Key LEFT;
    public static final /* enum */ Key UP_2;
    public static final /* enum */ Key DOWN_2;
    public static final /* enum */ Key RIGHT_2;
    public static final /* enum */ Key LEFT_2;
    public static final /* enum */ Key META_a;
    public static final /* enum */ Key META_b;
    public static final /* enum */ Key META_c;
    public static final /* enum */ Key META_d;
    public static final /* enum */ Key META_e;
    public static final /* enum */ Key META_f;
    public static final /* enum */ Key META_l;
    public static final /* enum */ Key META_u;
    public static final /* enum */ Key META_BACKSPACE;
    public static final /* enum */ Key DELETE;
    public static final /* enum */ Key INSERT;
    public static final /* enum */ Key PGUP;
    public static final /* enum */ Key PGDOWN;
    public static final /* enum */ Key HOME;
    public static final /* enum */ Key HOME_2;
    public static final /* enum */ Key END;
    public static final /* enum */ Key END_2;
    public static final /* enum */ Key META_CTRL_J;
    public static final /* enum */ Key META_CTRL_D;
    public static final /* enum */ Key CTRL_X_CTRL_U;
    public static final /* enum */ Key CTRL_LEFT;
    public static final /* enum */ Key CTRL_RIGHT;
    public static final /* enum */ Key CTRL_UP;
    public static final /* enum */ Key CTRL_DOWN;
    public static final /* enum */ Key ENTER;
    public static final /* enum */ Key ENTER_2;
    private final IntBuffer keyValues;
    private static final /* synthetic */ Key[] $VALUES;

    public static Key[] values() {
        return (Key[])$VALUES.clone();
    }

    public static Key valueOf(String name) {
        return Enum.valueOf(Key.class, name);
    }

    private Key(int[] keyValues) {
        this.keyValues = IntBuffer.allocate(keyValues.length);
        this.keyValues.put(keyValues);
    }

    public boolean isCharacter() {
        return this.keyValues.limit() == 1 && (this.keyValues.get(0) > 63 && this.keyValues.get(0) < 91 || this.keyValues.get(0) > 96 && this.keyValues.get(0) < 123);
    }

    public boolean isNumber() {
        return this.keyValues.limit() == 1 && this.keyValues.get(0) > 47 && this.keyValues.get(0) < 58;
    }

    public boolean isPrintable() {
        return Key.isPrintable(this.getKeyValues());
    }

    public static boolean isPrintable(int value) {
        if (Config.isOSPOSIXCompatible()) {
            return value > 31 && value < 127 || value > 127;
        }
        return value > 31 && value < 127 || value > 127 && value != WINDOWS_ESC.getFirstValue() && value != WINDOWS_ESC_2.getFirstValue();
    }

    public static boolean isPrintable(int[] keyValues) {
        return keyValues.length == 1 && Key.isPrintable(keyValues[0]);
    }

    public static boolean isPrintable(IntBuffer keyValues) {
        if (Config.isOSPOSIXCompatible()) {
            return keyValues.limit() == 1 && (keyValues.get(0) > 31 && keyValues.get(0) < 127 || keyValues.get(0) > 127);
        }
        return keyValues.limit() == 1 && (keyValues.get(0) > 31 && keyValues.get(0) < 127 || keyValues.get(0) > 127 && keyValues.get(0) != WINDOWS_ESC.getFirstValue() && keyValues.get(0) != WINDOWS_ESC_2.getFirstValue());
    }

    public char getAsChar() {
        return (char)this.keyValues.get(0);
    }

    public int[] getKeyValues() {
        return this.keyValues.array();
    }

    public String getKeyValuesAsString() {
        return Parser.fromCodePoints(this.keyValues.array());
    }

    public int getFirstValue() {
        return this.keyValues.get(0);
    }

    public static boolean startsWithEscape(int[] input) {
        return Config.isOSPOSIXCompatible() && input[0] == ESC.getFirstValue() || !Config.isOSPOSIXCompatible() && input[0] == WINDOWS_ESC.getFirstValue();
    }

    public static Key getKey(int[] otherValues) {
        for (Key key : Key.values()) {
            if (!key.equalTo(otherValues)) continue;
            return key;
        }
        return null;
    }

    public static Key findStartKey(int[] input) {
        for (Key key : Key.values()) {
            if (key == ESC || key == WINDOWS_ESC || !key.inputStartsWithKey(input)) continue;
            if (Config.isOSPOSIXCompatible() && key == CTRL_J) {
                return ENTER;
            }
            if (!Config.isOSPOSIXCompatible() && key == CTRL_M) {
                if (input.length > 1 && input[1] == CTRL_J.getFirstValue()) {
                    return ENTER_2;
                }
                return ENTER;
            }
            return key;
        }
        if (ESC.inputStartsWithKey(input)) {
            return ESC;
        }
        if (WINDOWS_ESC.inputStartsWithKey(input)) {
            return WINDOWS_ESC;
        }
        return null;
    }

    public static Key findStartKey(int[] input, int position) {
        for (Key key : Key.values()) {
            if (key == ESC || key == WINDOWS_ESC || !key.inputStartsWithKey(input, position)) continue;
            if (Config.isOSPOSIXCompatible() && key == CTRL_J) {
                return ENTER;
            }
            if (!Config.isOSPOSIXCompatible() && key == CTRL_M) {
                if (input.length > position + 1 && input[position + 1] == CTRL_J.getFirstValue()) {
                    return ENTER_2;
                }
                return ENTER;
            }
            return key;
        }
        if (ESC.inputStartsWithKey(input, position)) {
            return ESC;
        }
        if (WINDOWS_ESC.inputStartsWithKey(input, position)) {
            return WINDOWS_ESC;
        }
        return null;
    }

    public boolean inputStartsWithKey(int[] input) {
        if (this.keyValues.limit() > input.length) {
            return false;
        }
        for (int i = 0; i < this.keyValues.limit(); ++i) {
            if (this.keyValues.get(i) == input[i]) continue;
            return false;
        }
        return true;
    }

    public boolean inputStartsWithKey(int[] input, int position) {
        if (this.keyValues.limit() + position > input.length) {
            return false;
        }
        for (int i = 0; i < this.keyValues.limit(); ++i) {
            if (this.keyValues.get(i) == input[i + position]) continue;
            return false;
        }
        return true;
    }

    public boolean containKey(int[] input) {
        for (int i = 0; i < input.length; ++i) {
            if (input[i] != this.keyValues.get(0)) continue;
            if (this.keyValues.limit() == 1) {
                return true;
            }
            if (i + this.keyValues.limit() >= input.length) continue;
            int j = i;
            for (int k : this.keyValues.array()) {
                if (input[j] != k) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public boolean equalTo(int[] otherValues) {
        if (this.keyValues.limit() == otherValues.length) {
            for (int i = 0; i < this.keyValues.limit(); ++i) {
                if (this.keyValues.get(i) == otherValues[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalTo(KeyAction key) {
        if (this.keyValues.limit() == key.length()) {
            for (int i = 0; i < this.keyValues.limit(); ++i) {
                if (this.keyValues.get(i) == key.getCodePointAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getCodePointAt(int index) {
        return this.keyValues.get(index);
    }

    @Override
    public int length() {
        return this.keyValues.limit();
    }

    @Override
    public IntBuffer buffer() {
        return this.keyValues;
    }

    static {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        CTRL_AT = new Key(new int[]{0});
        CTRL_A = new Key(new int[]{1});
        CTRL_B = new Key(new int[]{2});
        CTRL_C = new Key(new int[]{3});
        CTRL_D = new Key(new int[]{4});
        CTRL_E = new Key(new int[]{5});
        CTRL_F = new Key(new int[]{6});
        CTRL_G = new Key(new int[]{7});
        CTRL_H = new Key(new int[]{8});
        CTRL_I = new Key(new int[]{9});
        CTRL_J = new Key(new int[]{10});
        CTRL_K = new Key(new int[]{11});
        CTRL_L = new Key(new int[]{12});
        CTRL_M = new Key(new int[]{13});
        CTRL_N = new Key(new int[]{14});
        CTRL_O = new Key(new int[]{15});
        CTRL_P = new Key(new int[]{16});
        CTRL_Q = new Key(new int[]{17});
        CTRL_R = new Key(new int[]{18});
        CTRL_S = new Key(new int[]{19});
        CTRL_T = new Key(new int[]{20});
        CTRL_U = new Key(new int[]{21});
        CTRL_V = new Key(new int[]{22});
        CTRL_W = new Key(new int[]{23});
        CTRL_X = new Key(new int[]{24});
        CTRL_Y = new Key(new int[]{25});
        CTRL_Z = new Key(new int[]{26});
        ESC = new Key(new int[]{27});
        FILE_SEPARATOR = new Key(new int[]{28});
        GROUP_SEPARATOR = new Key(new int[]{29});
        RECORD_SEPARATOR = new Key(new int[]{30});
        UNIT_SEPARATOR = new Key(new int[]{31});
        SPACE = new Key(new int[]{32});
        EXCLAMATION = new Key(new int[]{33});
        QUOTE = new Key(new int[]{34});
        HASH = new Key(new int[]{35});
        DOLLAR = new Key(new int[]{36});
        PERCENT = new Key(new int[]{37});
        AMPERSAND = new Key(new int[]{38});
        APOSTROPHE = new Key(new int[]{39});
        LEFT_PARANTHESIS = new Key(new int[]{40});
        RIGHT_PARANTHESIS = new Key(new int[]{41});
        STAR = new Key(new int[]{42});
        PLUS = new Key(new int[]{43});
        COMMA = new Key(new int[]{44});
        MINUS = new Key(new int[]{45});
        PERIOD = new Key(new int[]{46});
        SLASH = new Key(new int[]{47});
        ZERO = new Key(new int[]{48});
        ONE = new Key(new int[]{49});
        TWO = new Key(new int[]{50});
        THREE = new Key(new int[]{51});
        FOUR = new Key(new int[]{52});
        FIVE = new Key(new int[]{53});
        SIX = new Key(new int[]{54});
        SEVEN = new Key(new int[]{55});
        EIGHT = new Key(new int[]{56});
        NINE = new Key(new int[]{57});
        COLON = new Key(new int[]{58});
        SEMI_COLON = new Key(new int[]{59});
        LESS_THAN = new Key(new int[]{60});
        EQUALS = new Key(new int[]{61});
        GREATER_THAN = new Key(new int[]{62});
        QUESTION_MARK = new Key(new int[]{63});
        AT = new Key(new int[]{64});
        A = new Key(new int[]{65});
        B = new Key(new int[]{66});
        C = new Key(new int[]{67});
        D = new Key(new int[]{68});
        E = new Key(new int[]{69});
        F = new Key(new int[]{70});
        G = new Key(new int[]{71});
        H = new Key(new int[]{72});
        I = new Key(new int[]{73});
        J = new Key(new int[]{74});
        K = new Key(new int[]{75});
        L = new Key(new int[]{76});
        M = new Key(new int[]{77});
        N = new Key(new int[]{78});
        O = new Key(new int[]{79});
        P = new Key(new int[]{80});
        Q = new Key(new int[]{81});
        R = new Key(new int[]{82});
        S = new Key(new int[]{83});
        T = new Key(new int[]{84});
        U = new Key(new int[]{85});
        V = new Key(new int[]{86});
        W = new Key(new int[]{87});
        X = new Key(new int[]{88});
        Y = new Key(new int[]{89});
        Z = new Key(new int[]{90});
        LEFT_SQUARE_BRACKET = new Key(new int[]{91});
        BACKSLASH = new Key(new int[]{92});
        RIGHT_SQUARE_BRACKET = new Key(new int[]{93});
        HAT = new Key(new int[]{94});
        UNDERSCORE = new Key(new int[]{95});
        GRAVE = new Key(new int[]{96});
        a = new Key(new int[]{97});
        b = new Key(new int[]{98});
        c = new Key(new int[]{99});
        d = new Key(new int[]{100});
        e = new Key(new int[]{101});
        f = new Key(new int[]{102});
        g = new Key(new int[]{103});
        h = new Key(new int[]{104});
        i = new Key(new int[]{105});
        j = new Key(new int[]{106});
        k = new Key(new int[]{107});
        l = new Key(new int[]{108});
        m = new Key(new int[]{109});
        n = new Key(new int[]{110});
        o = new Key(new int[]{111});
        p = new Key(new int[]{112});
        q = new Key(new int[]{113});
        r = new Key(new int[]{114});
        s = new Key(new int[]{115});
        t = new Key(new int[]{116});
        u = new Key(new int[]{117});
        v = new Key(new int[]{118});
        w = new Key(new int[]{119});
        x = new Key(new int[]{120});
        y = new Key(new int[]{121});
        z = new Key(new int[]{122});
        LEFT_CURLY_BRACKET = new Key(new int[]{123});
        VERTICAL_BAR = new Key(new int[]{124});
        RIGHT_CURLY_BRACKET = new Key(new int[]{125});
        TILDE = new Key(new int[]{126});
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray4 = new int[1];
            nArray3 = nArray4;
            nArray4[0] = 127;
        } else {
            int[] nArray5 = new int[1];
            nArray3 = nArray5;
            nArray5[0] = 8;
        }
        BACKSPACE = new Key(nArray3);
        WINDOWS_ESC = new Key(new int[]{224});
        WINDOWS_ESC_2 = new Key(new int[]{341});
        UP = new Key(new int[]{ESC.getFirstValue(), 91, 65});
        DOWN = new Key(new int[]{ESC.getFirstValue(), 91, 66});
        RIGHT = new Key(new int[]{ESC.getFirstValue(), 91, 67});
        LEFT = new Key(new int[]{ESC.getFirstValue(), 91, 68});
        UP_2 = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("kcuu1", new int[]{27, 79, 65}));
        DOWN_2 = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("kcud1", new int[]{27, 79, 66}));
        RIGHT_2 = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("cuf1", new int[]{27, 79, 67}));
        LEFT_2 = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("kcub1", new int[]{27, 79, 68}));
        META_a = new Key(new int[]{ESC.getFirstValue(), a.getFirstValue()});
        META_b = new Key(new int[]{ESC.getFirstValue(), b.getFirstValue()});
        META_c = new Key(new int[]{ESC.getFirstValue(), c.getFirstValue()});
        META_d = new Key(new int[]{ESC.getFirstValue(), d.getFirstValue()});
        META_e = new Key(new int[]{ESC.getFirstValue(), e.getFirstValue()});
        META_f = new Key(new int[]{ESC.getFirstValue(), f.getFirstValue()});
        META_l = new Key(new int[]{ESC.getFirstValue(), l.getFirstValue()});
        META_u = new Key(new int[]{ESC.getFirstValue(), u.getFirstValue()});
        META_BACKSPACE = new Key(new int[]{ESC.getFirstValue(), BACKSPACE.getFirstValue()});
        DELETE = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("kdch1", new int[]{27, 91, 51, 126}));
        INSERT = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("kich1", new int[]{27, 91, 50, 126}));
        PGUP = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("kpp", new int[]{27, 91, 53, 126}));
        PGDOWN = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("knp", new int[]{27, 91, 54, 126}));
        HOME = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("khome", new int[]{27, 79, 72}));
        HOME_2 = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("home", new int[]{27, 91, 72}));
        END = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("kend", new int[]{27, 79, 70}));
        END_2 = new Key(InfoCmpHelper.getCurrentTranslatedCapabilityAsInts("end", new int[]{27, 91, 70}));
        META_CTRL_J = new Key(new int[]{ESC.getFirstValue(), 10});
        META_CTRL_D = new Key(new int[]{ESC.getFirstValue(), 4});
        CTRL_X_CTRL_U = new Key(new int[]{CTRL_X.getFirstValue(), CTRL_U.getFirstValue()});
        CTRL_LEFT = new Key(new int[]{ESC.getFirstValue(), 91, 49, 59, 53, 68});
        CTRL_RIGHT = new Key(new int[]{ESC.getFirstValue(), 91, 49, 59, 53, 67});
        CTRL_UP = new Key(new int[]{ESC.getFirstValue(), 91, 49, 59, 53, 65});
        CTRL_DOWN = new Key(new int[]{ESC.getFirstValue(), 91, 49, 59, 53, 66});
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray6 = new int[1];
            nArray2 = nArray6;
            nArray6[0] = 10;
        } else {
            int[] nArray7 = new int[1];
            nArray2 = nArray7;
            nArray7[0] = 13;
        }
        ENTER = new Key(nArray2);
        if (Config.isOSPOSIXCompatible()) {
            int[] nArray8 = new int[1];
            nArray = nArray8;
            nArray8[0] = 10;
        } else {
            int[] nArray9 = new int[2];
            nArray9[0] = 13;
            nArray = nArray9;
            nArray9[1] = 10;
        }
        ENTER_2 = new Key(nArray);
        $VALUES = new Key[]{CTRL_AT, CTRL_A, CTRL_B, CTRL_C, CTRL_D, CTRL_E, CTRL_F, CTRL_G, CTRL_H, CTRL_I, CTRL_J, CTRL_K, CTRL_L, CTRL_M, CTRL_N, CTRL_O, CTRL_P, CTRL_Q, CTRL_R, CTRL_S, CTRL_T, CTRL_U, CTRL_V, CTRL_W, CTRL_X, CTRL_Y, CTRL_Z, ESC, FILE_SEPARATOR, GROUP_SEPARATOR, RECORD_SEPARATOR, UNIT_SEPARATOR, SPACE, EXCLAMATION, QUOTE, HASH, DOLLAR, PERCENT, AMPERSAND, APOSTROPHE, LEFT_PARANTHESIS, RIGHT_PARANTHESIS, STAR, PLUS, COMMA, MINUS, PERIOD, SLASH, ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE, COLON, SEMI_COLON, LESS_THAN, EQUALS, GREATER_THAN, QUESTION_MARK, AT, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z, LEFT_SQUARE_BRACKET, BACKSLASH, RIGHT_SQUARE_BRACKET, HAT, UNDERSCORE, GRAVE, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, w, x, y, z, LEFT_CURLY_BRACKET, VERTICAL_BAR, RIGHT_CURLY_BRACKET, TILDE, BACKSPACE, WINDOWS_ESC, WINDOWS_ESC_2, UP, DOWN, RIGHT, LEFT, UP_2, DOWN_2, RIGHT_2, LEFT_2, META_a, META_b, META_c, META_d, META_e, META_f, META_l, META_u, META_BACKSPACE, DELETE, INSERT, PGUP, PGDOWN, HOME, HOME_2, END, END_2, META_CTRL_J, META_CTRL_D, CTRL_X_CTRL_U, CTRL_LEFT, CTRL_RIGHT, CTRL_UP, CTRL_DOWN, ENTER, ENTER_2};
    }
}

