/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.function.IntConsumer;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.impl.AbstractTerminal;
import org.aesh.terminal.utils.LinePipedInputStream;
import org.aesh.tty.Signal;
import org.aesh.tty.Size;

public class LineDisciplineTerminal
extends AbstractTerminal {
    private static final int PIPE_SIZE = 1024;
    protected final OutputStream masterOutput;
    protected final OutputStream slaveInputPipe;
    protected final InputStream slaveInput;
    protected final PrintWriter slaveWriter;
    protected final OutputStream slaveOutput;
    protected final String encoding;
    protected final Attributes attributes;
    protected Size size;
    protected IntConsumer application;
    protected CharsetDecoder decoder;
    protected ByteBuffer bytes;
    protected CharBuffer chars;

    public LineDisciplineTerminal(String name, String type, OutputStream masterOutput, String encoding) throws IOException {
        super(name, type);
        LinePipedInputStream input = new LinePipedInputStream(1024);
        this.slaveInputPipe = new PipedOutputStream(input);
        this.slaveInput = new FilterInputStream(input){};
        this.slaveOutput = new FilteringOutputStream();
        this.slaveWriter = new PrintWriter(new OutputStreamWriter(this.slaveOutput, encoding));
        this.masterOutput = masterOutput;
        this.encoding = encoding;
        this.attributes = new Attributes();
        this.size = new Size(160, 50);
        this.parseInfoCmp();
    }

    @Override
    public PrintWriter writer() {
        return this.slaveWriter;
    }

    @Override
    public InputStream input() {
        return this.slaveInput;
    }

    @Override
    public OutputStream output() {
        return this.slaveOutput;
    }

    @Override
    public Attributes getAttributes() {
        Attributes attr = new Attributes();
        attr.copy(this.attributes);
        return attr;
    }

    @Override
    public void setAttributes(Attributes attr) {
        this.attributes.copy(attr);
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    @Override
    public void raise(Signal signal) {
        assert (signal != null);
        this.echoSignal(signal);
        super.raise(signal);
    }

    public void processInputByte(int c) throws IOException {
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ISIG)) {
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VINTR)) {
                this.raise(Signal.INT);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VQUIT)) {
                this.raise(Signal.QUIT);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VSUSP)) {
                this.raise(Signal.TSTP);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VSTATUS)) {
                this.raise(Signal.INFO);
            }
        }
        if (c == 13) {
            if (this.attributes.getInputFlag(Attributes.InputFlag.IGNCR)) {
                return;
            }
            if (this.attributes.getInputFlag(Attributes.InputFlag.ICRNL)) {
                c = 10;
            }
        } else if (c == 10 && this.attributes.getInputFlag(Attributes.InputFlag.INLCR)) {
            c = 13;
        }
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ECHO)) {
            this.processOutputByte(c);
            this.masterOutput.flush();
        }
        this.slaveInputPipe.write(c);
        this.slaveInputPipe.flush();
    }

    protected void closeSlaveInputPipe() {
        try {
            this.slaveInputPipe.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void processOutputByte(int c) throws IOException {
        if (this.attributes.getOutputFlag(Attributes.OutputFlag.OPOST) && c == 10 && this.attributes.getOutputFlag(Attributes.OutputFlag.ONLCR)) {
            this.masterOutput.write(13);
            this.masterOutput.write(10);
            return;
        }
        this.masterOutput.write(c);
    }

    @Override
    public void close() throws IOException {
        try {
            this.slaveInputPipe.close();
        }
        finally {
            this.slaveWriter.close();
        }
    }

    private class FilteringOutputStream
    extends OutputStream {
        private FilteringOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            LineDisciplineTerminal.this.processOutputByte(b);
        }

        @Override
        public void flush() throws IOException {
            LineDisciplineTerminal.this.masterOutput.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            LineDisciplineTerminal.this.masterOutput.write(b);
        }

        @Override
        public void close() throws IOException {
            LineDisciplineTerminal.this.masterOutput.close();
        }
    }
}

