/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.aesh.terminal.formatting.TerminalString;
import org.aesh.util.ANSI;
import org.aesh.util.Config;
import org.aesh.util.ParsedLine;
import org.aesh.util.Parser;
import org.aesh.util.ParserStatus;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    @Test
    public void testFindStartsWith() {
        ArrayList<String> completionList = new ArrayList<String>(3);
        completionList.add("foobar");
        completionList.add("foobaz");
        completionList.add("foobor");
        completionList.add("foob");
        Assert.assertEquals((Object)"foob", (Object)Parser.findStartsWith(completionList));
        completionList.clear();
        completionList.add("foo");
        completionList.add("bar");
        Assert.assertEquals((Object)"", (Object)Parser.findStartsWith(completionList));
    }

    @Test
    public void testfindCurrentWordFromCursor() {
        Assert.assertEquals((Object)"", (Object)Parser.findCurrentWordFromCursor((String)" ", (int)1));
        Assert.assertEquals((Object)"foo", (Object)Parser.findCurrentWordFromCursor((String)"foo bar", (int)3));
        Assert.assertEquals((Object)"bar", (Object)Parser.findCurrentWordFromCursor((String)"foo bar", (int)6));
        Assert.assertEquals((Object)"foobar", (Object)Parser.findCurrentWordFromCursor((String)"foobar", (int)6));
        Assert.assertEquals((Object)"foo", (Object)Parser.findCurrentWordFromCursor((String)"foobar", (int)2));
        Assert.assertEquals((Object)"", (Object)Parser.findCurrentWordFromCursor((String)"ls  ", (int)3));
        Assert.assertEquals((Object)"foo", (Object)Parser.findCurrentWordFromCursor((String)"ls  foo", (int)6));
        Assert.assertEquals((Object)"foo", (Object)Parser.findCurrentWordFromCursor((String)"ls  foo bar", (int)6));
        Assert.assertEquals((Object)"bar", (Object)Parser.findCurrentWordFromCursor((String)"ls  foo bar", (int)10));
        Assert.assertEquals((Object)"ba", (Object)Parser.findCurrentWordFromCursor((String)"ls  foo bar", (int)9));
        Assert.assertEquals((Object)"foo", (Object)Parser.findCurrentWordFromCursor((String)"ls foo ", (int)6));
        Assert.assertEquals((Object)"o", (Object)Parser.findCurrentWordFromCursor((String)"ls o org/jboss/aeshell/Shell.class", (int)4));
        Assert.assertEquals((Object)"", (Object)Parser.findCurrentWordFromCursor((String)"ls  org/jboss/aeshell/Shell.class", (int)3));
    }

    @Test
    public void testFindCurrentWordWithEscapedSpaceToCursor() {
        Assert.assertEquals((Object)"foo bar", (Object)Parser.findCurrentWordFromCursor((String)"foo\\ bar", (int)7));
        Assert.assertEquals((Object)"foo ba", (Object)Parser.findCurrentWordFromCursor((String)"foo\\ bar", (int)6));
        Assert.assertEquals((Object)"foo bar", (Object)Parser.findCurrentWordFromCursor((String)"ls  foo\\ bar", (int)11));
    }

    @Test
    public void testFindClosestWholeWordToCursor() {
        Assert.assertEquals((Object)"foo", (Object)Parser.findWordClosestToCursor((String)"ls  foo bar", (int)6));
        Assert.assertEquals((Object)"", (Object)Parser.findWordClosestToCursor((String)" ", (int)1));
        Assert.assertEquals((Object)"foo", (Object)Parser.findWordClosestToCursor((String)"foo bar", (int)1));
        Assert.assertEquals((Object)"foo", (Object)Parser.findWordClosestToCursor((String)"foo bar", (int)3));
        Assert.assertEquals((Object)"foobar", (Object)Parser.findWordClosestToCursor((String)"foobar", (int)6));
        Assert.assertEquals((Object)"foobar", (Object)Parser.findWordClosestToCursor((String)"foobar", (int)2));
        Assert.assertEquals((Object)"", (Object)Parser.findWordClosestToCursor((String)"ls  ", (int)3));
        Assert.assertEquals((Object)"o", (Object)Parser.findWordClosestToCursor((String)"ls o org/jboss/aeshell/Shell.class", (int)4));
        Assert.assertEquals((Object)"", (Object)Parser.findWordClosestToCursor((String)"ls  org/jboss/aeshell/Shell.class", (int)3));
        Assert.assertEquals((Object)"foo", (Object)Parser.findWordClosestToCursor((String)"foo bar foo", (int)3));
    }

    @Test
    public void testFindClosestWholeWordToCursorEscapedSpace() {
        Assert.assertEquals((Object)"foo bar", (Object)Parser.findWordClosestToCursor((String)"foo\\ bar", (int)7));
        Assert.assertEquals((Object)"foo bar", (Object)Parser.findWordClosestToCursor((String)"ls  foo\\ bar", (int)11));
    }

    @Test
    public void testFindEscapedSpaceWordCloseToEnd() {
        Assert.assertEquals((Object)"ls\\ foo", (Object)Parser.findEscapedSpaceWordCloseToEnd((String)" ls\\ foo"));
        Assert.assertEquals((Object)"foo\\ bar", (Object)Parser.findEscapedSpaceWordCloseToEnd((String)"ls foo\\ bar"));
        Assert.assertEquals((Object)"bar", (Object)Parser.findEscapedSpaceWordCloseToEnd((String)"ls foo bar"));
        Assert.assertEquals((Object)"ls\\ foo\\ bar", (Object)Parser.findEscapedSpaceWordCloseToEnd((String)"ls\\ foo\\ bar"));
        Assert.assertEquals((Object)"\\ ls\\ foo\\ bar", (Object)Parser.findEscapedSpaceWordCloseToEnd((String)"\\ ls\\ foo\\ bar"));
        Assert.assertEquals((Object)"ls\\ foo\\ bar", (Object)Parser.findEscapedSpaceWordCloseToEnd((String)" ls\\ foo\\ bar"));
        Assert.assertEquals((Object)"ls\\ foo\\ bar\\ ", (Object)Parser.findEscapedSpaceWordCloseToEnd((String)" ls\\ foo\\ bar\\ "));
        Assert.assertEquals((Object)"", (Object)Parser.findEscapedSpaceWordCloseToEnd((String)" ls\\ foo\\ bar\\  "));
    }

    @Test
    public void testFindEscapedSpaceWord() {
        Assert.assertTrue((boolean)Parser.doWordContainOnlyEscapedSpace((String)"foo\\ bar"));
        Assert.assertTrue((boolean)Parser.doWordContainOnlyEscapedSpace((String)"foo\\ bar\\ "));
        Assert.assertTrue((boolean)Parser.doWordContainOnlyEscapedSpace((String)"\\ foo\\ bar\\ "));
        Assert.assertFalse((boolean)Parser.doWordContainOnlyEscapedSpace((String)" foo\\ bar\\ "));
        Assert.assertFalse((boolean)Parser.doWordContainOnlyEscapedSpace((String)"foo bar\\ "));
        Assert.assertFalse((boolean)Parser.doWordContainOnlyEscapedSpace((String)"foo bar"));
    }

    @Test
    public void testChangeWordWithSpaces() {
        Assert.assertEquals((Object)"foo bar", (Object)Parser.switchEscapedSpacesToSpacesInWord((String)"foo\\ bar"));
        Assert.assertEquals((Object)" foo bar", (Object)Parser.switchEscapedSpacesToSpacesInWord((String)"\\ foo\\ bar"));
        Assert.assertEquals((Object)" foo bar ", (Object)Parser.switchEscapedSpacesToSpacesInWord((String)"\\ foo\\ bar\\ "));
        Assert.assertEquals((Object)" foo bar", (Object)Parser.switchEscapedSpacesToSpacesInWord((String)"\\ foo bar"));
        Assert.assertEquals((Object)"foo\\ bar", (Object)Parser.switchSpacesToEscapedSpacesInWord((String)"foo bar"));
        Assert.assertEquals((Object)"\\ foo\\ bar", (Object)Parser.switchSpacesToEscapedSpacesInWord((String)" foo bar"));
        Assert.assertEquals((Object)"\\ foo\\ bar\\ ", (Object)Parser.switchSpacesToEscapedSpacesInWord((String)" foo bar "));
    }

    @Test
    public void testSplitBySizeKeepWords() {
        String words = "foo to bar is how it is i guess";
        List out = Parser.splitBySizeKeepWords((String)words, (int)10);
        Assert.assertEquals((Object)"foo to bar", out.get(0));
        Assert.assertEquals((Object)"is how it", out.get(1));
        Assert.assertEquals((Object)"is i guess", out.get(2));
        words = "It is an error to use a backslash prior to any alphabetic";
        out = Parser.splitBySizeKeepWords((String)words, (int)20);
        Assert.assertEquals((Object)"It is an error to", out.get(0));
        Assert.assertEquals((Object)"use a backslash", out.get(1));
        Assert.assertEquals((Object)"prior to any", out.get(2));
        Assert.assertEquals((Object)"alphabetic", out.get(3));
    }

    @Test
    public void testTrim() {
        Assert.assertEquals((Object)"foo", (Object)Parser.trim((String)"  foo "));
        Assert.assertEquals((Object)"bar foo", (Object)Parser.trim((String)"bar foo "));
        Assert.assertEquals((Object)"bar foo", (Object)Parser.trim((String)" bar foo"));
        Assert.assertEquals((Object)"\\ foo\\ ", (Object)Parser.trim((String)"\\ foo\\  "));
    }

    @Test
    public void testFindFirstWord() {
        Assert.assertEquals((Object)"foo", (Object)Parser.findFirstWord((String)" foo \\ bar"));
        Assert.assertEquals((Object)"foo", (Object)Parser.findFirstWord((String)" foo bar baz"));
        Assert.assertEquals((Object)"foo", (Object)Parser.findFirstWord((String)"foo bar baz"));
        Assert.assertEquals((Object)"foobar", (Object)Parser.findFirstWord((String)"foobar baz"));
        Assert.assertEquals((Object)"foobarbaz", (Object)Parser.findFirstWord((String)"foobarbaz"));
    }

    @Test
    public void testTrimInFront() {
        Assert.assertEquals((Object)"foo ", (Object)Parser.trimInFront((String)"  foo "));
        Assert.assertEquals((Object)"foo", (Object)Parser.trimInFront((String)"  foo"));
        Assert.assertEquals((Object)"foo", (Object)Parser.trimInFront((String)"foo"));
    }

    @Test
    public void testFormatDisplayList() {
        ArrayList<String> list = new ArrayList<String>();
        String s1 = "this is a loooooong string thats longer than the terminal width";
        list.add(s1);
        Assert.assertEquals((Object)(s1 + "  " + Config.getLineSeparator()), (Object)Parser.formatDisplayList(list, (int)20, (int)20));
    }

    @Test
    public void testPadLeft() {
        Assert.assertEquals((Object)" foo", (Object)Parser.padLeft((int)4, (String)"foo"));
        Assert.assertEquals((Object)"   foo", (Object)Parser.padLeft((int)6, (String)"foo"));
    }

    @Test
    public void testFindNumberOfSpaces() {
        Assert.assertEquals((long)4L, (long)Parser.findNumberOfSpacesInWord((String)"this is a word "));
        Assert.assertEquals((long)4L, (long)Parser.findNumberOfSpacesInWord((String)"this is a word !"));
        Assert.assertEquals((long)5L, (long)Parser.findNumberOfSpacesInWord((String)" this is a word !"));
        Assert.assertEquals((long)4L, (long)Parser.findNumberOfSpacesInWord((String)" this is a\\ word !"));
    }

    @Test
    public void testContainsDollar() {
        Assert.assertTrue((boolean)Parser.containsNonEscapedDollar((String)"foo $bar"));
        Assert.assertFalse((boolean)Parser.containsNonEscapedDollar((String)"foo bar"));
        Assert.assertFalse((boolean)Parser.containsNonEscapedDollar((String)"foo \\$bar"));
        Assert.assertFalse((boolean)Parser.containsNonEscapedDollar((String)"foo \\$bar\\$"));
        Assert.assertFalse((boolean)Parser.containsNonEscapedDollar((String)"\\$foo \\$bar\\$"));
        Assert.assertTrue((boolean)Parser.containsNonEscapedDollar((String)"$foo \\$bar\\$"));
        Assert.assertTrue((boolean)Parser.containsNonEscapedDollar((String)"\\$foo \\$bar$"));
    }

    @Test
    public void testDoesStringContainQuote() {
        Assert.assertFalse((boolean)Parser.doesStringContainOpenQuote((String)"foo bar is bar"));
        Assert.assertFalse((boolean)Parser.doesStringContainOpenQuote((String)"\"foo bar is bar is foo is bar\""));
        Assert.assertFalse((boolean)Parser.doesStringContainOpenQuote((String)"\"foo bar \"is bar is \"foo is bar\""));
        Assert.assertFalse((boolean)Parser.doesStringContainOpenQuote((String)"'foo bar \"is bar is \"foo is bar'"));
        Assert.assertTrue((boolean)Parser.doesStringContainOpenQuote((String)"\"foo bar is bar is \"foo is bar\""));
        Assert.assertFalse((boolean)Parser.doesStringContainOpenQuote((String)"\"foo bar is bar is \\\"foo is bar\""));
        Assert.assertTrue((boolean)Parser.doesStringContainOpenQuote((String)"\"foo bar is bar is \\\"foo is bar'"));
    }

    @Test
    public void testOriginalInput() {
        String input = "echo foo -i bar";
        ParsedLine line = Parser.findAllWords((String)input);
        Assert.assertEquals((Object)input, (Object)line.line());
    }

    @Test
    public void testFindAllWords() {
        ParsedLine line = Parser.findAllWords((String)"   foo bar\\ baz 12345 ", (int)5);
        Assert.assertEquals((Object)"foo", line.words().get(0));
        Assert.assertEquals((Object)"bar baz", line.words().get(1));
        Assert.assertEquals((Object)"12345", line.words().get(2));
        Assert.assertEquals((Object)"foo", (Object)line.selectedWord());
        Assert.assertEquals((long)2L, (long)line.wordCursor());
        line = Parser.findAllWords((String)"man < foo\\ bar ", (int)14);
        Assert.assertEquals((Object)"man", line.words().get(0));
        Assert.assertEquals((Object)"<", line.words().get(1));
        Assert.assertEquals((Object)"foo bar", line.words().get(2));
        Assert.assertEquals((Object)"foo bar", (Object)line.selectedWord());
        Assert.assertEquals((long)7L, (long)line.wordCursor());
        line = Parser.findAllWords((String)"cd A\\ Directory\\ With\\ Spaces", (int)2);
        Assert.assertEquals((Object)"cd", line.words().get(0));
        Assert.assertEquals((Object)"A Directory With Spaces", line.words().get(1));
        Assert.assertEquals((Object)"cd", (Object)line.selectedWord());
        Assert.assertEquals((long)2L, (long)line.wordCursor());
        line = Parser.findAllWords((String)"cd A\\ ", (int)5);
        Assert.assertEquals((Object)"cd", line.words().get(0));
        Assert.assertEquals((Object)"A ", line.words().get(1));
        Assert.assertEquals((Object)"A ", (Object)line.selectedWord());
        Assert.assertEquals((long)1L, (long)line.wordCursor());
        line = Parser.findAllWords((String)"cd A\\", (int)4);
        Assert.assertEquals((Object)"cd", line.words().get(0));
        Assert.assertEquals((Object)"A\\", line.words().get(1));
        Assert.assertEquals((Object)"A\\", (Object)line.selectedWord());
        Assert.assertEquals((long)1L, (long)line.wordCursor());
        line = Parser.findAllWords((String)"ls --files /tmp/A\\ ");
        Assert.assertEquals((Object)"ls", line.words().get(0));
        Assert.assertEquals((Object)"--files", line.words().get(1));
        Assert.assertEquals((Object)"/tmp/A ", line.words().get(2));
        line = Parser.findAllWords((String)"..\\..\\..\\..\\..\\..\\..\\temp\\foo.txt");
        Assert.assertEquals((Object)"..\\..\\..\\..\\..\\..\\..\\temp\\foo.txt", line.words().get(0));
    }

    @Test
    public void testFindAllQuotedWords() {
        ParsedLine line = Parser.findAllWords((String)"foo bar \"baz 12345\" ", (int)19);
        Assert.assertEquals((Object)"foo", line.words().get(0));
        Assert.assertEquals((Object)"bar", line.words().get(1));
        Assert.assertEquals((Object)"baz 12345", line.words().get(2));
        Assert.assertEquals((Object)"", (Object)line.selectedWord());
        Assert.assertEquals((long)0L, (long)line.wordCursor());
        line = Parser.findAllWords((String)"java -cp \"foo/bar\" \"Example\"");
        Assert.assertEquals((Object)"foo/bar", line.words().get(2));
        Assert.assertEquals((Object)"Example", line.words().get(3));
        line = Parser.findAllWords((String)"'foo/bar/' Example\\ 1");
        Assert.assertEquals((Object)"foo/bar/", line.words().get(0));
        Assert.assertEquals((Object)"Example 1", line.words().get(1));
        line = Parser.findAllWords((String)"man -f='foo bar/' Example\\ 1 foo");
        Assert.assertEquals((Object)"man", line.words().get(0));
        Assert.assertEquals((Object)"-f=foo bar/", line.words().get(1));
        Assert.assertEquals((Object)"Example 1", line.words().get(2));
        Assert.assertEquals((Object)"foo", line.words().get(3));
        line = Parser.findAllWords((String)"man -f='foo/bar/ Example\\ 1");
        Assert.assertEquals((Object)ParserStatus.UNCLOSED_QUOTE, (Object)line.status());
        line = Parser.findAllWords((String)"man -f='foo/bar/' Example\\ 1\"");
        Assert.assertEquals((Object)ParserStatus.UNCLOSED_QUOTE, (Object)line.status());
        line = Parser.findAllWords((String)"-s 'redirectUris=[\"http://localhost:8080/blah/*\"]'");
        Assert.assertEquals((Object)"-s", line.words().get(0));
        Assert.assertEquals((Object)"redirectUris=[\"http://localhost:8080/blah/*\"]", line.words().get(1));
    }

    @Test
    public void testFindAllTernaryQuotedWords() {
        ParsedLine line = Parser.findAllWords((String)"\"\"  \"\"");
        Assert.assertEquals((Object)"  ", line.words().get(0));
        line = Parser.findAllWords((String)"\"\"  foo bar \"\"");
        Assert.assertEquals((Object)"  foo bar ", line.words().get(0));
        line = Parser.findAllWords((String)"\"\"  \"foo bar\" \"\"");
        Assert.assertEquals((Object)"  \"foo bar\" ", line.words().get(0));
        line = Parser.findAllWords((String)"gah bah-bah  \"\"  \"foo bar\" \"\" boo");
        Assert.assertEquals((Object)"gah", line.words().get(0));
        Assert.assertEquals((Object)"bah-bah", line.words().get(1));
        Assert.assertEquals((Object)"  \"foo bar\" ", line.words().get(2));
        Assert.assertEquals((Object)"boo", line.words().get(3));
        line = Parser.findAllWords((String)" \"\"/s-ramp/wsdl/Operation[xp2:matches(@name, 'submit.*')]\"\"");
        Assert.assertEquals((Object)"/s-ramp/wsdl/Operation[xp2:matches(@name, 'submit.*')]", line.words().get(0));
        line = Parser.findAllWords((String)" \"\"/s-ramp/ext/${type} \\ \"\"");
        Assert.assertEquals((Object)"/s-ramp/ext/${type} \\ ", line.words().get(0));
    }

    @Test
    public void testFormatDisplayCompactListTerminalString() {
        TerminalString terminalLong = new TerminalString("This string is too long to terminal width");
        TerminalString terminalShort1 = new TerminalString("str1");
        TerminalString terminalShort2 = new TerminalString("str2");
        TerminalString terminalShort3 = new TerminalString("str3");
        TerminalString terminalShort4 = new TerminalString("str4");
        TerminalString terminalLonger1 = new TerminalString("longer1");
        TerminalString terminalLonger2 = new TerminalString("longer2");
        TerminalString terminalLonger3 = new TerminalString("longer3");
        Assert.assertEquals((Object)(terminalLong.toString() + Config.getLineSeparator()), (Object)Parser.formatDisplayCompactListTerminalString(Collections.singletonList(terminalLong), (int)10));
        Assert.assertEquals((Object)(terminalShort1.toString() + "  " + terminalShort2.toString() + Config.getLineSeparator()), (Object)Parser.formatDisplayCompactListTerminalString(Arrays.asList(terminalShort1, terminalShort2), (int)20));
        Assert.assertEquals((Object)(terminalShort1.toString() + Config.getLineSeparator() + terminalShort2.toString() + Config.getLineSeparator()), (Object)Parser.formatDisplayCompactListTerminalString(Arrays.asList(terminalShort1, terminalShort2), (int)10));
        Assert.assertEquals((Object)(terminalShort1.toString() + "  " + terminalShort3.toString() + Config.getLineSeparator() + terminalShort2.toString() + Config.getLineSeparator()), (Object)Parser.formatDisplayCompactListTerminalString(Arrays.asList(terminalShort1, terminalShort2, terminalShort3), (int)15));
        Assert.assertEquals((Object)(terminalShort1.toString() + "  " + terminalShort3.toString() + Config.getLineSeparator() + terminalShort2.toString() + "  " + terminalShort4.toString() + Config.getLineSeparator()), (Object)Parser.formatDisplayCompactListTerminalString(Arrays.asList(terminalShort1, terminalShort2, terminalShort3, terminalShort4), (int)15));
        Assert.assertEquals((Object)(terminalLonger1.toString() + "  " + terminalShort1.toString() + Config.getLineSeparator() + terminalLonger2.toString() + Config.getLineSeparator() + terminalLonger3.toString() + Config.getLineSeparator()), (Object)Parser.formatDisplayCompactListTerminalString(Arrays.asList(terminalLonger1, terminalLonger2, terminalLonger3, terminalShort1), (int)15));
    }

    @Test
    public void testStripAwayAnsiPattern() {
        Assert.assertEquals((Object)"foo", (Object)Parser.stripAwayAnsiCodes((String)"\u001b[0;30mfoo"));
        Assert.assertEquals((Object)"foo", (Object)Parser.stripAwayAnsiCodes((String)(ANSI.BOLD + "\u001b[0;46m" + "foo")));
        Assert.assertEquals((Object)"foo", (Object)Parser.stripAwayAnsiCodes((String)("foo" + ANSI.BOLD + "\u001b[0;46m")));
        Assert.assertEquals((Object)"foo", (Object)Parser.stripAwayAnsiCodes((String)(ANSI.ALTERNATE_BUFFER + "foo")));
        Assert.assertEquals((Object)"foo", (Object)Parser.stripAwayAnsiCodes((String)"\u001b[6nfoo"));
        Assert.assertEquals((Object)"foo bar", (Object)Parser.stripAwayAnsiCodes((String)"foo\u001b[0m bar"));
    }

    @Test
    public void testIsTrimmedArrayEmpty() {
        int[] input = new int[]{};
        Assert.assertTrue((boolean)Parser.isTrimmedArrayEmpty((int[])input));
        input = new int[]{32, 32};
        Assert.assertTrue((boolean)Parser.isTrimmedArrayEmpty((int[])input));
        input = new int[]{32, 32, 68};
        Assert.assertFalse((boolean)Parser.isTrimmedArrayEmpty((int[])input));
        input = new int[]{68, 32, 32};
        Assert.assertFalse((boolean)Parser.isTrimmedArrayEmpty((int[])input));
        input = new int[]{70};
        Assert.assertFalse((boolean)Parser.isTrimmedArrayEmpty((int[])input));
    }

    @Test
    public void testArrayContains() {
        int[] source = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        int[] target = new int[]{7};
        Assert.assertTrue((boolean)Parser.arrayContains((int[])source, (int[])target));
        target = new int[]{7, 8};
        Assert.assertTrue((boolean)Parser.arrayContains((int[])source, (int[])target));
        target = new int[]{7, 8, 9};
        Assert.assertFalse((boolean)Parser.arrayContains((int[])source, (int[])target));
        target = new int[]{1, 2, 3, 4};
        Assert.assertTrue((boolean)Parser.arrayContains((int[])source, (int[])target));
        target = new int[]{1, 2, 3, 4, 6};
        Assert.assertFalse((boolean)Parser.arrayContains((int[])source, (int[])target));
        target = new int[]{0, 1, 2, 3, 4};
        Assert.assertFalse((boolean)Parser.arrayContains((int[])source, (int[])target));
    }

    @Test
    public void testArrayIndexOf() {
        int[] source = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        int[] target = new int[]{7};
        Assert.assertEquals((long)6L, (long)Parser.arrayIndexOf((int[])source, (int[])target));
        target = new int[]{7, 8};
        Assert.assertEquals((long)6L, (long)Parser.arrayIndexOf((int[])source, (int[])target));
        target = new int[]{7, 8, 9};
        Assert.assertEquals((long)-1L, (long)Parser.arrayIndexOf((int[])source, (int[])target));
        target = new int[]{1, 2, 3, 4};
        Assert.assertEquals((long)0L, (long)Parser.arrayIndexOf((int[])source, (int[])target));
        target = new int[]{1, 2, 3, 4, 6};
        Assert.assertEquals((long)-1L, (long)Parser.arrayIndexOf((int[])source, (int[])target));
        target = new int[]{0, 1, 2, 3, 4};
        Assert.assertEquals((long)-1L, (long)Parser.arrayIndexOf((int[])source, (int[])target));
    }
}

