/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.alias;

import java.io.File;
import java.io.IOException;
import org.aesh.readline.alias.AliasManager;
import org.aesh.utils.Config;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AliasManagerTest {
    private AliasManager manager;
    private File fooFile;

    @Before
    public void setTup() {
        try {
            this.fooFile = new File("foo");
            this.manager = new AliasManager(this.fooFile, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @After
    public void cleanup() {
        this.fooFile.delete();
    }

    @Test
    public void testParseAlias() {
        Assert.assertNull((Object)this.manager.parseAlias("alias foo2='bar -s -h'"));
        Assert.assertNull((Object)this.manager.parseAlias("alias foo=bar"));
        Assert.assertNull((Object)this.manager.parseAlias("alias foo3=bar --help"));
        String out = this.manager.parseAlias("alias foo");
        Assert.assertEquals((Object)("alias foo='bar'" + Config.getLineSeparator()), (Object)out);
        out = this.manager.parseAlias("alias foo2");
        Assert.assertEquals((Object)("alias foo2='bar -s -h'" + Config.getLineSeparator()), (Object)out);
        out = this.manager.parseAlias("alias foo3");
        Assert.assertEquals((Object)("alias foo3='bar --help'" + Config.getLineSeparator()), (Object)out);
        out = this.manager.parseAlias("alias");
        StringBuilder sb = new StringBuilder();
        sb.append("alias foo='bar'").append(Config.getLineSeparator()).append("alias foo2='bar -s -h'").append(Config.getLineSeparator()).append("alias foo3='bar --help'").append(Config.getLineSeparator());
        Assert.assertEquals((Object)sb.toString(), (Object)out);
        out = this.manager.parseAlias("alias --help");
        Assert.assertEquals((Object)("alias: usage: alias [name[=value] ... ]" + Config.getLineSeparator()), (Object)out);
        out = this.manager.parseAlias("alias        --help");
        Assert.assertEquals((Object)("alias: usage: alias [name[=value] ... ]" + Config.getLineSeparator()), (Object)out);
    }

    @Test
    public void testUnalias() {
        this.manager.parseAlias("alias foo2='bar -s -h'");
        this.manager.parseAlias("alias foo=bar");
        this.manager.parseAlias("alias foo3=bar --help");
        this.manager.removeAlias("unalias foo3");
        Assert.assertEquals((Object)("unalias: foo3: not found" + Config.getLineSeparator()), (Object)this.manager.removeAlias("unalias foo3"));
        String out = this.manager.removeAlias("unalias --help");
        Assert.assertEquals((Object)("unalias: usage: unalias name [name ...]" + Config.getLineSeparator()), (Object)out);
        out = this.manager.removeAlias("unalias        --help");
        Assert.assertEquals((Object)("unalias: usage: unalias name [name ...]" + Config.getLineSeparator()), (Object)out);
    }

    @Test
    public void testPrintAllAliases() {
        String alias = "alias foo='bar'";
        this.manager.parseAlias(alias);
        Assert.assertEquals((Object)(alias + Config.getLineSeparator()), (Object)this.manager.printAllAliases());
    }

    @Test
    public void testPersist() throws Exception {
        this.manager.persist();
        Assert.assertTrue((String)"The persistent file should be a file", (boolean)this.fooFile.isFile());
    }
}

