/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal;

import java.util.function.Consumer;
import org.aesh.terminal.tty.Signal;

public class EventDecoder
implements Consumer<int[]> {
    private final int intr;
    private final int susp;
    private final int eof;
    private Consumer<Signal> signalHandler;
    private Consumer<int[]> inputHandler;

    public EventDecoder() {
        this.intr = 3;
        this.eof = 4;
        this.susp = 26;
    }

    public EventDecoder(int intr, int eof, int susp) {
        this.intr = intr;
        this.eof = eof;
        this.susp = susp;
    }

    public Consumer<Signal> getSignalHandler() {
        return this.signalHandler;
    }

    public void setSignalHandler(Consumer<Signal> signalHandler) {
        this.signalHandler = signalHandler;
    }

    public Consumer<int[]> getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(Consumer<int[]> inputHandler) {
        this.inputHandler = inputHandler;
    }

    @Override
    public void accept(int[] input) {
        if (this.signalHandler != null) {
            int index = 0;
            while (index < input.length) {
                int val = input[index];
                Signal event = null;
                if (val == this.intr) {
                    event = Signal.INT;
                } else if (val == this.susp) {
                    event = Signal.SUSP;
                } else if (val == this.eof) {
                    event = Signal.EOF;
                }
                if (event != null && this.signalHandler != null) {
                    this.signalHandler.accept(event);
                    int[] a = new int[input.length - index - 1];
                    System.arraycopy(input, index + 1, a, 0, a.length);
                    input = a;
                    index = 0;
                    continue;
                }
                ++index;
            }
        }
        if (input.length > 0 && this.inputHandler != null) {
            this.inputHandler.accept(input);
        }
    }
}

