/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.tty;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.aesh.terminal.Connection;
import org.aesh.terminal.TestBase;
import org.aesh.terminal.tty.Signal;
import org.junit.Test;

public abstract class TtyTestBase
extends TestBase {
    protected Charset charset = StandardCharsets.UTF_8;

    protected abstract void assertConnect(String var1) throws Exception;

    protected abstract String assertReadString(int var1) throws Exception;

    protected abstract void assertWrite(String var1) throws Exception;

    protected abstract void assertWriteln(String var1) throws Exception;

    protected abstract void server(Consumer<Connection> var1);

    protected abstract void resize(int var1, int var2) throws Exception;

    protected void assertDisconnect(boolean clean) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void assertConnect() throws Exception {
        this.assertConnect(null);
    }

    protected final void assertWrite(int ... codePoints) throws Exception {
        this.assertWrite(this.fromCodePoints(codePoints));
    }

    @Test
    public void testWrite() throws Exception {
        AtomicInteger requestCount = new AtomicInteger();
        this.server(conn -> {
            requestCount.incrementAndGet();
            conn.stdoutHandler().accept(new int[]{37, 32});
        });
        this.assertConnect();
        this.assertEquals("% ", this.assertReadString(2));
        this.assertEquals(1, requestCount.get());
    }

    @Test
    public void testRead() throws Exception {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        this.server(conn -> conn.setStdinHandler(data -> {
            queue.add(data);
            conn.stdoutHandler().accept(new int[]{104, 101, 108, 108, 111});
        }));
        this.assertConnect();
        this.assertWriteln("");
        int[] data = (int[])queue.poll(10L, TimeUnit.SECONDS);
        this.assertTrue(Arrays.equals(new int[]{13}, data));
        this.assertEquals("hello", this.assertReadString(5));
    }

    @Test
    public void testSignalInterleaving() throws Exception {
        StringBuilder buffer = new StringBuilder();
        AtomicInteger count = new AtomicInteger();
        this.server(conn -> {
            conn.setStdinHandler(event -> this.appendCodePoints((int[])event, buffer));
            conn.setSignalHandler(event -> {
                if (event == Signal.INT) {
                    switch (count.get()) {
                        case 0: {
                            this.assertEquals("hello", buffer.toString());
                            buffer.setLength(0);
                            count.set(1);
                            break;
                        }
                        case 1: {
                            this.assertEquals("bye", buffer.toString());
                            count.set(2);
                            this.testComplete();
                            break;
                        }
                        default: {
                            this.fail("Not expected");
                        }
                    }
                }
            });
        });
        this.assertConnect();
        this.assertWrite(104, 101, 108, 108, 111, 3, 98, 121, 101, 3);
        this.await();
    }

    @Test
    public void testSignals() throws Exception {
        StringBuilder buffer = new StringBuilder();
        AtomicInteger count = new AtomicInteger();
        this.server(conn -> {
            conn.setStdinHandler(event -> this.appendCodePoints((int[])event, buffer));
            conn.setSignalHandler(event -> {
                switch (count.get()) {
                    case 0: {
                        this.assertEquals(Signal.INT, event);
                        count.set(1);
                        break;
                    }
                    case 1: {
                        this.assertEquals(Signal.EOF, event);
                        count.set(2);
                        break;
                    }
                    case 2: {
                        this.assertEquals(Signal.SUSP, event);
                        count.set(3);
                        this.testComplete();
                        break;
                    }
                    default: {
                        this.fail("Not expected");
                    }
                }
            });
        });
        this.assertConnect();
        this.assertWrite(3, 4, 26);
        this.await();
    }

    @Test
    public void testServerDisconnect() throws Exception {
        CountDownLatch closedLatch = new CountDownLatch(1);
        this.server(conn -> {
            conn.setStdinHandler(bytes -> conn.close());
            conn.setCloseHandler(v -> closedLatch.countDown());
        });
        this.assertConnect();
        this.assertWrite("whatever");
        this.assertTrue(closedLatch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testClientDisconnectClean() throws Exception {
        this.testClientDisconnect(true);
    }

    @Test
    public void testClientDisconnect() throws Exception {
        this.testClientDisconnect(false);
    }

    private void testClientDisconnect(boolean clean) throws Exception {
        CountDownLatch disconnectLatch = new CountDownLatch(1);
        CountDownLatch closedLatch = new CountDownLatch(1);
        this.server(conn -> {
            disconnectLatch.countDown();
            conn.setCloseHandler(v -> closedLatch.countDown());
        });
        this.assertConnect();
        this.assertTrue(disconnectLatch.await(10L, TimeUnit.SECONDS));
        this.assertDisconnect(clean);
        this.assertTrue(closedLatch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testTerminalType() throws Exception {
        Consumer<String> assertTerm = term -> {
            if (term.equals("xterm") || term.equals("vt100")) {
                this.testComplete();
            } else {
                this.fail("Unexpected term " + term);
            }
        };
        this.server(conn -> {
            if (conn.device().type() != null) {
                assertTerm.accept(conn.device().type());
            } else {
                this.testComplete();
            }
        });
        this.assertConnect("xterm");
        this.assertWrite("bye");
        this.await();
    }

    @Test
    public void testSize() throws Exception {
        this.server(conn -> {
            if (conn.size() != null) {
                this.assertEquals(80, conn.size().getWidth());
                this.assertEquals(24, conn.size().getHeight());
                this.testComplete();
            } else {
                conn.setSizeHandler(size -> {
                    this.assertEquals(80, conn.size().getWidth());
                    this.assertEquals(24, conn.size().getHeight());
                    this.testComplete();
                });
            }
        });
        this.assertConnect();
        this.await();
    }

    @Test
    public void testResize() throws Exception {
        this.server(conn -> conn.setSizeHandler(size -> {
            this.assertEquals(40, conn.size().getWidth());
            this.assertEquals(12, conn.size().getHeight());
            this.testComplete();
        }));
        this.assertConnect();
        this.resize(40, 12);
        this.await();
    }

    @Test
    public void testConnectionClose() throws Exception {
        AtomicInteger closeCount = new AtomicInteger();
        this.server(conn -> {
            conn.setCloseHandler(v -> {
                if (closeCount.incrementAndGet() > 1) {
                    this.fail("Closed call several times");
                } else {
                    this.testComplete();
                }
            });
            conn.setStdinHandler(text -> conn.close());
        });
        this.assertConnect();
        this.assertWrite("bye");
        this.await();
    }

    public boolean checkDisconnected() {
        throw new UnsupportedOperationException();
    }

    @Test
    public void testConnectionCloseImmediatly() throws Exception {
        this.server(conn -> {
            conn.setCloseHandler(v -> new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 100; ++i) {
                        if (TtyTestBase.this.checkDisconnected()) {
                            TtyTestBase.this.testComplete();
                            return;
                        }
                        try {
                            Thread.sleep(10L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            TtyTestBase.this.fail(e);
                        }
                    }
                }
            }.start());
            conn.close();
        });
        this.assertConnect();
        this.await();
    }

    protected void assertThreading(Thread connThread, Thread schedulerThread) throws Exception {
    }

    @Test
    public void testDifferentCharset() throws Exception {
        this.charset = StandardCharsets.ISO_8859_1;
        this.server(conn -> conn.write("\u20ac"));
        this.assertConnect();
        String s = this.assertReadString(1);
        this.assertEquals("?", s);
    }
}

