/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.io;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aesh.io.Decoder;
import org.junit.Assert;
import org.junit.Test;

public class DecoderTest {
    private void assertDecode(List<String> chars, int ... bytes) {
        ArrayList abc = new ArrayList();
        Decoder decoder = new Decoder(Charset.forName("UTF-8"), event -> {
            StringBuilder sb = new StringBuilder();
            for (int cp : event) {
                sb.appendCodePoint(cp);
            }
            abc.add(sb.toString());
        });
        byte[] data = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            data[i] = (byte)bytes[i];
        }
        decoder.write(data);
        Assert.assertEquals(chars, abc);
    }

    @Test
    public void testDecoder() throws Exception {
        this.assertDecode(Arrays.asList("ABCD", "E"), 65, 66, 67, 68, 69);
        this.assertDecode(Arrays.asList("\rfoo"), 13, 102, 111, 111);
        this.assertDecode(Arrays.asList("\u001b["), 27, 91);
    }
}

