/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.ssh.tty;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.function.Consumer;
import org.aesh.terminal.Connection;
import org.aesh.terminal.ssh.TtyCommand;
import org.aesh.terminal.tty.TtyTestBase;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.junit.After;

public abstract class SshTtyTestBase
extends TtyTestBase {
    JSch jsch = new JSch();
    Session session;
    ChannelShell channel;
    InputStream in;
    OutputStream out;
    private SshServer sshd;

    protected void assertConnect(String term) throws Exception {
        if (this.session != null) {
            throw SshTtyTestBase.failure((String)"Already a session");
        }
        this.session = this.jsch.getSession("whatever", "localhost", 5000);
        this.session.setPassword("whocares");
        this.session.setUserInfo(new UserInfo(){

            public String getPassphrase() {
                return null;
            }

            public String getPassword() {
                return null;
            }

            public boolean promptPassword(String s) {
                return false;
            }

            public boolean promptPassphrase(String s) {
                return false;
            }

            public boolean promptYesNo(String s) {
                return true;
            }

            public void showMessage(String s) {
            }
        });
        this.session.connect();
        this.channel = (ChannelShell)this.session.openChannel("shell");
        if (term != null) {
            this.channel.setPtyType(term);
        }
        this.channel.connect();
        this.in = this.channel.getInputStream();
        this.out = this.channel.getOutputStream();
    }

    public boolean checkDisconnected() {
        try {
            return this.in != null && this.in.read() == -1;
        }
        catch (IOException e) {
            throw SshTtyTestBase.failure((Throwable)e);
        }
    }

    protected void assertDisconnect(boolean clean) throws Exception {
        if (clean) {
            this.session.disconnect();
        } else {
            Field socketField = this.session.getClass().getDeclaredField("socket");
            socketField.setAccessible(true);
            Socket socket = (Socket)socketField.get(this.session);
            socket.close();
        }
    }

    protected void resize(int width, int height) {
        this.channel.setPtySize(width, height, width * 8, height * 8);
    }

    protected void assertWrite(String s) throws Exception {
        this.out.write(s.getBytes(this.charset));
        this.out.flush();
    }

    protected String assertReadString(int len) throws Exception {
        byte[] buf = new byte[len];
        while (len > 0) {
            int count = this.in.read(buf, buf.length - len, len);
            if (count == -1) {
                throw SshTtyTestBase.failure((String)"Could not read enough");
            }
            len -= count;
        }
        return new String(buf, "UTF-8");
    }

    protected void assertWriteln(String s) throws Exception {
        this.assertWrite(s + "\r");
    }

    protected abstract SshServer createServer();

    protected TtyCommand createConnection(Consumer<Connection> onConnect) {
        return new TtyCommand(this.charset, onConnect);
    }

    protected void server(Consumer<Connection> onConnect) {
        if (this.sshd != null) {
            throw SshTtyTestBase.failure((String)"Already a server");
        }
        try {
            this.sshd = this.createServer();
            this.sshd.setPort(5000);
            this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(new File("hostkey.ser").toPath()));
            this.sshd.setPasswordAuthenticator((username, password, session) -> true);
            this.sshd.setShellFactory(() -> this.createConnection(onConnect));
            this.sshd.start();
        }
        catch (Exception e) {
            throw SshTtyTestBase.failure((Throwable)e);
        }
    }

    @After
    public void after() throws Exception {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.channel != null) {
            try {
                this.channel.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.session != null) {
            try {
                this.session.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sshd != null && !this.sshd.isClosed()) {
            try {
                this.sshd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

