/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.ssh.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.terminal.ssh.netty.NettyIoAcceptor;
import org.aesh.terminal.ssh.netty.NettyIoWriteFuture;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class NettyIoSession
extends CloseableUtils.AbstractCloseable
implements IoSession {
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private final NettyIoAcceptor acceptor;
    private final IoHandler handler;
    private ChannelHandlerContext context;
    private SocketAddress remoteAddr;
    private ChannelFuture prev;
    private final DefaultCloseFuture closeFuture = new DefaultCloseFuture(null);
    private final long id;
    private static final Logger LOGGER = Logger.getLogger(NettyIoSession.class.getName());
    final ChannelInboundHandlerAdapter adapter = new ChannelInboundHandlerAdapter(){

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            NettyIoSession.this.context = ctx;
            ((NettyIoSession)NettyIoSession.this).acceptor.channelGroup.add((Object)ctx.channel());
            ((NettyIoSession)NettyIoSession.this).acceptor.ioService.sessions.put(NettyIoSession.this.id, NettyIoSession.this);
            NettyIoSession.this.prev = (ChannelFuture)NettyIoSession.this.context.newPromise().setSuccess();
            NettyIoSession.this.remoteAddr = NettyIoSession.this.context.channel().remoteAddress();
            ((NettyIoSession)NettyIoSession.this).acceptor.factory.handlerBridge.sessionCreated(NettyIoSession.this.handler, NettyIoSession.this);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            ((NettyIoSession)NettyIoSession.this).acceptor.ioService.sessions.remove(NettyIoSession.this.id);
            ((NettyIoSession)NettyIoSession.this).acceptor.factory.handlerBridge.sessionClosed(NettyIoSession.this.handler, NettyIoSession.this);
            NettyIoSession.this.context = null;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ByteBuf buf = (ByteBuf)msg;
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(0, bytes);
            ((NettyIoSession)NettyIoSession.this).acceptor.factory.handlerBridge.messageReceived(NettyIoSession.this.handler, NettyIoSession.this, (Readable)new ByteArrayBuffer(bytes));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            LOGGER.log(Level.WARNING, "exception during io, closing.", cause);
            ctx.close();
        }
    };

    public NettyIoSession(NettyIoAcceptor acceptor, IoHandler handler) {
        this.acceptor = acceptor;
        this.handler = handler;
        this.id = acceptor.ioService.sessionSeq.incrementAndGet();
    }

    public void execute(Runnable task) {
        this.context.channel().eventLoop().execute(task);
    }

    public void schedule(Runnable task, long delay, TimeUnit unit) {
        this.context.channel().eventLoop().schedule(task, delay, unit);
    }

    public long getId() {
        return this.id;
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddr;
    }

    public SocketAddress getLocalAddress() {
        return this.context.channel().localAddress();
    }

    public IoWriteFuture write(Buffer buffer) {
        ByteBuf buf = Unpooled.buffer((int)buffer.available());
        buf.writeBytes(buffer.array(), buffer.rpos(), buffer.available());
        NettyIoWriteFuture msg = new NettyIoWriteFuture();
        ChannelPromise next = this.context.newPromise();
        this.prev.addListener(whatever -> {
            if (this.context != null) {
                this.context.writeAndFlush((Object)buf, next);
            }
        });
        this.prev = next;
        next.addListener(fut -> {
            if (fut.isSuccess()) {
                msg.setValue(Boolean.TRUE);
            } else {
                msg.setValue(fut.cause());
            }
        });
        return msg;
    }

    public IoService getService() {
        return this.acceptor.ioService;
    }

    protected CloseFuture doCloseGracefully() {
        this.context.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).addListener(fut -> this.closeFuture.setClosed());
        return this.closeFuture;
    }

    protected void doCloseImmediately() {
        this.context.close();
        super.doCloseImmediately();
    }
}

