/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet;

import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.aesh.terminal.telnet.Option;
import org.aesh.terminal.telnet.TelnetConnection;
import org.aesh.terminal.telnet.TelnetHandler;
import org.aesh.terminal.telnet.TelnetTestBase;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.SimpleOptionHandler;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.junit.Test;

public abstract class TelnetHandlerTest
extends TelnetTestBase {
    private void testOptionValue(Supplier<TelnetHandler> factory, TelnetOptionHandler optionHandler) throws Exception {
        this.server.start(factory);
        this.client.setOptionHandler(optionHandler);
        this.client.connect("localhost", 4000);
        this.await();
    }

    @Test
    public void testRejectEcho() throws Exception {
        final AtomicReference serverValue = new AtomicReference();
        EchoOptionHandler optionHandler = new EchoOptionHandler(false, false, false, false);
        this.testOptionValue(() -> new TelnetHandler(){

            protected void onOpen(TelnetConnection conn) {
                conn.writeWillOption(Option.ECHO);
            }

            protected void onEcho(boolean echo) {
                serverValue.set(echo);
                TelnetHandlerTest.this.testComplete();
            }
        }, (TelnetOptionHandler)optionHandler);
        this.assertEquals(false, serverValue.get());
        this.assertEquals(false, optionHandler.getAcceptRemote());
    }

    @Test
    public void testAcceptEcho() throws Exception {
        final AtomicReference serverValue = new AtomicReference();
        EchoOptionHandler optionHandler = new EchoOptionHandler(false, false, false, true);
        this.testOptionValue(() -> new TelnetHandler(){

            protected void onOpen(TelnetConnection conn) {
                conn.writeWillOption(Option.ECHO);
            }

            protected void onEcho(boolean echo) {
                serverValue.set(echo);
                TelnetHandlerTest.this.testComplete();
            }
        }, (TelnetOptionHandler)optionHandler);
        this.assertEquals(true, serverValue.get());
        this.assertEquals(true, optionHandler.getAcceptRemote());
    }

    @Test
    public void testRejectSGA() throws Exception {
        final AtomicReference serverValue = new AtomicReference();
        SuppressGAOptionHandler optionHandler = new SuppressGAOptionHandler(false, false, false, false);
        this.testOptionValue(() -> new TelnetHandler(){

            protected void onOpen(TelnetConnection conn) {
                conn.writeWillOption(Option.SGA);
            }

            protected void onSGA(boolean sga) {
                serverValue.set(sga);
                TelnetHandlerTest.this.testComplete();
            }
        }, (TelnetOptionHandler)optionHandler);
        this.assertEquals(false, serverValue.get());
        this.assertEquals(false, optionHandler.getAcceptRemote());
    }

    @Test
    public void testAcceptSGA() throws Exception {
        final AtomicReference serverValue = new AtomicReference();
        SuppressGAOptionHandler optionHandler = new SuppressGAOptionHandler(false, false, false, true);
        this.testOptionValue(() -> new TelnetHandler(){

            protected void onOpen(TelnetConnection conn) {
                conn.writeWillOption(Option.SGA);
            }

            protected void onSGA(boolean sga) {
                serverValue.set(sga);
                TelnetHandlerTest.this.testComplete();
            }
        }, (TelnetOptionHandler)optionHandler);
        this.assertEquals(true, serverValue.get());
        this.assertEquals(true, optionHandler.getAcceptRemote());
    }

    @Test
    public void testRejectNAWS() throws Exception {
        final AtomicReference serverValue = new AtomicReference();
        WindowSizeOptionHandler optionHandler = new WindowSizeOptionHandler(20, 10, false, false, false, false);
        this.testOptionValue(new Supplier<TelnetHandler>(){

            @Override
            public TelnetHandler get() {
                return new TelnetHandler(){

                    protected void onOpen(TelnetConnection conn) {
                        conn.writeDoOption(Option.NAWS);
                    }

                    protected void onNAWS(boolean naws) {
                        serverValue.set(naws);
                        TelnetHandlerTest.this.testComplete();
                    }

                    protected void onSize(int width, int height) {
                        super.onSize(width, height);
                    }
                };
            }
        }, (TelnetOptionHandler)optionHandler);
        this.assertEquals(false, serverValue.get());
        this.assertEquals(false, optionHandler.getAcceptLocal());
    }

    @Test
    public void testAcceptNAWS() throws Exception {
        final AtomicReference serverValue = new AtomicReference();
        final AtomicReference size = new AtomicReference();
        WindowSizeOptionHandler optionHandler = new WindowSizeOptionHandler(20, 10, false, false, true, false);
        this.testOptionValue(() -> new TelnetHandler(){

            protected void onOpen(TelnetConnection conn) {
                conn.writeDoOption(Option.NAWS);
            }

            protected void onNAWS(boolean naws) {
                serverValue.set(naws);
            }

            protected void onSize(int width, int height) {
                size.set(new int[]{width, height});
                TelnetHandlerTest.this.testComplete();
            }
        }, (TelnetOptionHandler)optionHandler);
        this.assertEquals(true, serverValue.get());
        this.assertEquals(true, optionHandler.getAcceptLocal());
        this.assertEquals(2, ((int[])size.get()).length);
        this.assertEquals(20, ((int[])size.get())[0]);
        this.assertEquals(10, ((int[])size.get())[1]);
    }

    @Test
    public void testOpen() throws Exception {
        this.server.start(() -> new TelnetHandler(){

            protected void onOpen(TelnetConnection conn) {
                TelnetHandlerTest.this.testComplete();
            }
        });
        this.client.connect("localhost", 4000);
        this.await();
    }

    @Test
    public void testClientDisconnect() throws Exception {
        this.server.start(() -> new TelnetHandler(){

            protected void onClose() {
                TelnetHandlerTest.this.testComplete();
            }
        });
        try {
            this.client.connect("localhost", 4000);
        }
        finally {
            this.client.disconnect();
        }
        this.await();
    }

    @Test
    public void testServerClose() throws Exception {
        this.server.start(() -> new TelnetHandler(){

            protected void onOpen(TelnetConnection conn) {
                conn.close();
            }

            protected void onClose() {
                TelnetHandlerTest.this.testComplete();
            }
        });
        this.client.connect("localhost", 4000);
        this.await();
    }

    @Test
    public void testSend() throws Exception {
        this.server.start(() -> new TelnetHandler(){

            protected void onOpen(TelnetConnection conn) {
                conn.write(new byte[]{0, 1, 2, 3, 127, -128, -127, -1});
            }
        });
        this.client.connect("localhost", 4000);
        byte[] data = this.client.assertReadBytes(8);
        this.assertEquals((byte)0, data[0]);
        this.assertEquals((byte)1, data[1]);
        this.assertEquals((byte)2, data[2]);
        this.assertEquals((byte)3, data[3]);
        this.assertEquals((byte)127, data[4]);
        this.assertEquals((byte)0, data[5]);
        this.assertEquals((byte)1, data[6]);
        this.assertEquals((byte)127, data[7]);
    }

    @Test
    public void testReceive() throws Exception {
        this.server.start(() -> new TelnetHandler(){

            protected void onData(byte[] data) {
                TelnetHandlerTest.this.assertEquals(7, data.length);
                TelnetHandlerTest.this.assertEquals((byte)0, data[0]);
                TelnetHandlerTest.this.assertEquals((byte)1, data[1]);
                TelnetHandlerTest.this.assertEquals((byte)2, data[2]);
                TelnetHandlerTest.this.assertEquals((byte)3, data[3]);
                TelnetHandlerTest.this.assertEquals((byte)127, data[4]);
                TelnetHandlerTest.this.assertEquals((byte)-128, data[5]);
                TelnetHandlerTest.this.assertEquals((byte)-127, data[6]);
                TelnetHandlerTest.this.testComplete();
            }
        });
        this.client.connect("localhost", 4000).write(0, 1, 2, 3, 127, -128, -127).flush();
        this.await();
    }

    @Test
    public void testWillUnknownOption() throws Exception {
        this.server.start(TelnetHandler::new);
        this.client.registerNotifHandler((negotiation_code, option_code) -> {
            if (option_code == 47) {
                this.assertEquals(2, negotiation_code);
                this.testComplete();
            }
        });
        this.client.setOptionHandler((TelnetOptionHandler)new SimpleOptionHandler(47, true, false, false, false));
        this.client.connect("localhost", 4000);
        this.await();
    }

    @Test
    public void testDoUnknownOption() throws Exception {
        this.server.start(TelnetHandler::new);
        this.client.registerNotifHandler((negotiation_code, option_code) -> {
            if (option_code == 47) {
                this.assertEquals(4, negotiation_code);
                this.testComplete();
            }
        });
        this.client.setOptionHandler((TelnetOptionHandler)new SimpleOptionHandler(47, false, true, false, false));
        this.client.connect("localhost", 4000);
        this.await();
    }

    @Test
    public void testReceiveBinary() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.server.start(() -> new TelnetHandler(){

            protected void onOpen(TelnetConnection conn) {
                conn.writeDoOption(Option.BINARY);
            }

            protected void onSendBinary(boolean binary) {
                if (binary) {
                    TelnetHandlerTest.this.fail("Was not expecting a do for binary option");
                }
            }

            protected void onReceiveBinary(boolean binary) {
                if (binary) {
                    latch.countDown();
                } else {
                    TelnetHandlerTest.this.fail("Was not expecting a won't for binary option");
                }
            }

            protected void onData(byte[] data) {
                TelnetHandlerTest.this.assertEquals(1, data.length);
                TelnetHandlerTest.this.assertEquals((byte)-1, data[0]);
                TelnetHandlerTest.this.testComplete();
            }
        });
        this.client.setOptionHandler((TelnetOptionHandler)new SimpleOptionHandler(0, false, false, true, false));
        this.client.connect("localhost", 4000);
        latch.await();
        this.client.writeDirectAndFlush(-1, -1);
        this.await();
    }

    @Test
    public void testSendBinary() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.server.start(new Supplier<TelnetHandler>(){

            @Override
            public TelnetHandler get() {
                return new TelnetHandler(){
                    private TelnetConnection conn;

                    protected void onOpen(TelnetConnection conn) {
                        this.conn = conn;
                        conn.writeWillOption(Option.BINARY);
                    }

                    protected void onSendBinary(boolean binary) {
                        if (binary) {
                            this.conn.write(new byte[]{104, 101, 108, 108, 111, -1});
                            latch.countDown();
                        } else {
                            TelnetHandlerTest.this.fail("Was not expecting a don't for binary option");
                        }
                    }

                    protected void onReceiveBinary(boolean binary) {
                        if (binary) {
                            TelnetHandlerTest.this.fail("Was not expecting a will for binary option");
                        }
                    }
                };
            }
        });
        this.client.setOptionHandler((TelnetOptionHandler)new SimpleOptionHandler(0, false, false, false, true));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.client.client.registerSpyStream((OutputStream)baos);
        this.client.connect("localhost", 4000);
        latch.await();
        InputStreamReader reader = new InputStreamReader(this.client.client.getInputStream());
        char[] hello = new char[5];
        int num = reader.read(hello);
        this.assertEquals(5, num);
        this.assertEquals("hello", new String(hello));
        byte[] data = baos.toByteArray();
        this.assertEquals(10, data.length);
        this.assertEquals((byte)104, data[3]);
        this.assertEquals((byte)101, data[4]);
        this.assertEquals((byte)108, data[5]);
        this.assertEquals((byte)108, data[6]);
        this.assertEquals((byte)111, data[7]);
        this.assertEquals((byte)-1, data[8]);
        this.assertEquals((byte)-1, data[9]);
    }
}

