/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.io;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.aesh.terminal.io.Decoder;
import org.aesh.terminal.io.Encoder;
import org.junit.Assert;
import org.junit.Test;

public class EncoderTest {
    public void decodeEndcode(String incoming, String[] expected) {
        Charset charset = Charset.forName("UTF-8");
        ArrayList result = new ArrayList();
        Decoder decoder = new Decoder(charset, event -> result.add(event));
        byte[] output = new byte[4];
        Encoder encoder = new Encoder(charset, event -> {
            for (int i = 0; i < ((byte[])event).length; ++i) {
                output[i] = event[i];
            }
        });
        decoder.write(incoming.getBytes());
        for (int i = 0; i < expected.length; ++i) {
            encoder.accept((int[])result.get(i));
            for (int j = 0; j < expected[i].length(); ++j) {
                Assert.assertEquals((long)expected[i].getBytes()[j], (long)output[j]);
            }
        }
    }

    @Test
    public void testInputs() {
        this.decodeEndcode("foo", new String[]{"foo"});
        this.decodeEndcode("foo bar!!??", new String[]{"foo ", "bar!", "!??"});
        this.decodeEndcode("\r", new String[]{"\r"});
    }
}

