/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.io;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.aesh.terminal.io.Decoder;
import org.junit.Assert;
import org.junit.Test;

public class DecoderTest {
    private void assertDecode(int initialSize, List<String> chars, int ... bytes) {
        ArrayList abc = new ArrayList();
        Decoder decoder = new Decoder(initialSize, Charset.forName("UTF-8"), event -> {
            StringBuilder sb = new StringBuilder();
            for (int cp : event) {
                sb.appendCodePoint(cp);
            }
            abc.add(sb.toString());
        });
        byte[] data = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            data[i] = (byte)bytes[i];
        }
        decoder.write(data);
        Assert.assertEquals(chars, abc);
    }

    @Test
    public void testDecoder() {
        this.assertDecode(4, Arrays.asList("ABCD", "E"), 65, 66, 67, 68, 69);
        this.assertDecode(4, Arrays.asList("\rfoo"), 13, 102, 111, 111);
        this.assertDecode(4, Arrays.asList("\u001b["), 27, 91);
    }

    @Test
    public void testDecoderOverflow() {
        this.assertDecode(2, Arrays.asList("AB", "CD", "E"), 65, 66, 67, 68, 69);
        this.assertDecode(3, Arrays.asList("ABC", "DE"), 65, 66, 67, 68, 69);
        this.assertDecode(4, Arrays.asList("ABCD", "E"), 65, 66, 67, 68, 69);
        this.assertDecode(5, Arrays.asList("ABCDE"), 65, 66, 67, 68, 69);
        this.assertDecode(6, Arrays.asList("ABCDE"), 65, 66, 67, 68, 69);
    }

    @Test
    public void testDecoderUnderflow() {
        final ArrayList codePoints = new ArrayList();
        Decoder decoder = new Decoder(10, Charset.forName("UTF-8"), (Consumer)new Consumer<int[]>(){

            @Override
            public void accept(int[] event) {
                codePoints.addAll(DecoderTest.list(event));
            }
        });
        decoder.write(new byte[]{-30});
        Assert.assertEquals((long)0L, (long)codePoints.size());
        decoder.write(new byte[]{-126});
        Assert.assertEquals((long)0L, (long)codePoints.size());
        decoder.write(new byte[]{-84});
        Assert.assertEquals((long)1L, (long)codePoints.size());
        Assert.assertEquals((long)8364L, (long)((Integer)codePoints.get(0)).intValue());
    }

    public static List<Integer> list(int ... list) {
        ArrayList<Integer> result = new ArrayList<Integer>(list.length);
        for (int i : list) {
            result.add(i);
        }
        return result;
    }
}

