/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.tty;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.aesh.terminal.tty.TtyOutputMode;
import org.junit.Assert;
import org.junit.Test;

public class TtyOutputModeTest {
    @Test
    public void testTranslateLFToCRLF() {
        this.assertOutput("a", "a");
        this.assertOutput("\r\n", "\n");
        this.assertOutput("a\r\n", "a\n");
        this.assertOutput("\r\na", "\na");
        this.assertOutput("a\r\nb\r\nc", "a\nb\nc");
    }

    private void assertOutput(String expected, String actual) {
        Stream.Builder builder = Stream.builder();
        TtyOutputMode out = new TtyOutputMode(builder);
        out.accept(this.toCodePoints(actual));
        String result = this.fromCodePoints(builder.build().flatMapToInt(IntStream::of).toArray());
        Assert.assertEquals((Object)expected, (Object)result);
    }

    int[] toCodePoints(String s) {
        return s.codePoints().toArray();
    }

    String fromCodePoints(int[] input) {
        return new String(input, 0, input.length);
    }
}

