/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.http.server;

import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.terminal.http.HttpTtyConnection;
import org.xnio.ChannelListener;
import org.xnio.Pooled;

public class WebSocketTtyConnection
extends HttpTtyConnection {
    private static Logger log = Logger.getLogger(WebSocketTtyConnection.class.getName());
    private WebSocketChannel webSocketChannel;
    private final ScheduledExecutorService executor;
    private Set<WebSocketChannel> readonlyChannels = new HashSet<WebSocketChannel>();

    protected void write(byte[] buffer) {
        if (this.isOpen()) {
            this.sendBinary(buffer, this.webSocketChannel);
        }
        this.readonlyChannels.forEach(wsChannel -> this.sendBinary(buffer, (WebSocketChannel)wsChannel));
    }

    private void sendBinary(byte[] buffer, WebSocketChannel webSocketChannel) {
        WebSockets.sendBinary((ByteBuffer)ByteBuffer.wrap(buffer), (WebSocketChannel)webSocketChannel, null);
    }

    public void execute(Runnable task) {
        this.executor.execute(task);
    }

    public void schedule(Runnable task, long delay, TimeUnit unit) {
        this.executor.schedule(task, delay, unit);
    }

    public WebSocketTtyConnection(WebSocketChannel webSocketChannel, ScheduledExecutorService executor) {
        this.webSocketChannel = webSocketChannel;
        this.executor = executor;
        this.registerWebSocketChannelListener(webSocketChannel);
        webSocketChannel.resumeReceives();
    }

    private void registerWebSocketChannelListener(WebSocketChannel webSocketChannel) {
        AbstractReceiveListener listener = new AbstractReceiveListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                log.log(Level.FINE, "Server received full binary message");
                Pooled pulledData = message.getData();
                try {
                    ByteBuffer[] resource = (ByteBuffer[])pulledData.getResource();
                    ByteBuffer byteBuffer = WebSockets.mergeBuffers((ByteBuffer[])resource);
                    String msg = new String(byteBuffer.array());
                    log.log(Level.FINE, "Sending message to decoder: " + msg);
                    WebSocketTtyConnection.this.writeToDecoder(msg);
                }
                finally {
                    pulledData.discard();
                }
            }
        };
        webSocketChannel.getReceiveSetter().set((ChannelListener)listener);
    }

    public boolean isOpen() {
        return this.webSocketChannel != null && this.webSocketChannel.isOpen();
    }

    public void setWebSocketChannel(WebSocketChannel webSocketChannel) {
        this.webSocketChannel = webSocketChannel;
    }

    public void addReadonlyChannel(WebSocketChannel webSocketChannel) {
        this.readonlyChannels.add(webSocketChannel);
    }

    public void removeReadonlyChannel(WebSocketChannel webSocketChannel) {
        this.readonlyChannels.remove(webSocketChannel);
    }

    public void removeWebSocketChannel() {
        this.webSocketChannel = null;
    }

    public void close() {
        Consumer closeHandler = this.getCloseHandler();
        if (closeHandler != null) {
            closeHandler.accept(null);
        }
    }
}

