/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.ssh;

import com.jcraft.jsch.JSchException;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import org.aesh.terminal.TestBase;
import org.aesh.terminal.ssh.netty.AsyncAuth;
import org.aesh.terminal.ssh.netty.AsyncUserAuthServiceFactory;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerConnectionServiceFactory;
import org.apache.sshd.util.EchoShellFactory;
import org.junit.After;
import org.junit.Test;

public abstract class AsyncAuthTestBase
extends TestBase {
    SshServer server;
    private PasswordAuthenticator authenticator;

    public void startServer() throws Exception {
        this.startServer(null);
    }

    public void startServer(Integer timeout) throws Exception {
        if (this.server != null) {
            throw AsyncAuthTestBase.failure((String)"Server already started");
        }
        this.server = SshServer.setUpDefaultServer();
        if (timeout != null) {
            this.server.setProperties(Collections.singletonMap("auth-timeout", timeout.toString()));
        }
        this.server.setPort(5000);
        this.server.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(new File("hostkey.ser").toPath()));
        this.server.setPasswordAuthenticator((username, password, sess) -> this.authenticator.authenticate(username, password, sess));
        this.server.setShellFactory((Factory)new EchoShellFactory());
        this.server.setServiceFactories(Arrays.asList(ServerConnectionServiceFactory.INSTANCE, AsyncUserAuthServiceFactory.INSTANCE));
        this.server.start();
    }

    @After
    public void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testSyncAuthFailed() throws Exception {
        this.startServer();
        this.authenticator = (username, password, sess) -> false;
        this.assertFalse(this.authenticate());
    }

    @Test
    public void testSyncAuthSucceeded() throws Exception {
        this.startServer();
        this.authenticator = (username, password, sess) -> true;
        this.assertTrue(this.authenticate());
    }

    @Test
    public void testAsyncAuthFailed() throws Exception {
        this.startServer();
        this.authenticator = (username, password, sess) -> {
            final AsyncAuth auth = new AsyncAuth();
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        auth.setAuthed(false);
                    }
                }
            }.start();
            throw auth;
        };
        this.assertFalse(this.authenticate());
    }

    @Test
    public void testAsyncAuthSucceeded() throws Exception {
        this.startServer();
        this.authenticator = (username, password, sess) -> {
            final AsyncAuth auth = new AsyncAuth();
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        auth.setAuthed(true);
                    }
                }
            }.start();
            throw auth;
        };
        this.assertTrue(this.authenticate());
    }

    @Test
    public void testAsyncAuthTimeout() throws Exception {
        this.startServer(500);
        this.authenticator = (username, password, sess) -> {
            throw new AsyncAuth();
        };
        try {
            this.authenticate();
        }
        catch (JSchException e) {
            this.assertTrue("Unexpected failure " + e.getMessage(), e.getMessage().startsWith("SSH_MSG_DISCONNECT"));
        }
    }

    @Test
    public void testAsyncAuthSucceededAfterTimeout() throws Exception {
        this.startServer(500);
        this.authenticator = (username, password, sess) -> {
            final AsyncAuth auth = new AsyncAuth();
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        auth.setAuthed(true);
                    }
                }
            }.start();
            throw auth;
        };
        try {
            this.authenticate();
        }
        catch (JSchException e) {
            this.assertTrue("Unexpected failure " + e.getMessage(), e.getMessage().startsWith("SSH_MSG_DISCONNECT"));
        }
    }

    protected abstract boolean authenticate() throws Exception;
}

