/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.ssh;

import java.util.Map;
import org.aesh.terminal.Attributes;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.server.Environment;

public class SSHAttributesBuilder {
    private Environment environment;

    private SSHAttributesBuilder() {
    }

    public static SSHAttributesBuilder builder() {
        return new SSHAttributesBuilder();
    }

    public SSHAttributesBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public Attributes build() {
        Attributes attr = new Attributes();
        for (Map.Entry e : this.environment.getPtyModes().entrySet()) {
            switch ((PtyMode)e.getKey()) {
                case VINTR: {
                    attr.setControlChar(Attributes.ControlChar.VINTR, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VQUIT: {
                    attr.setControlChar(Attributes.ControlChar.VQUIT, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VERASE: {
                    attr.setControlChar(Attributes.ControlChar.VERASE, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VKILL: {
                    attr.setControlChar(Attributes.ControlChar.VKILL, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VEOF: {
                    attr.setControlChar(Attributes.ControlChar.VEOF, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VEOL: {
                    attr.setControlChar(Attributes.ControlChar.VEOL, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VEOL2: {
                    attr.setControlChar(Attributes.ControlChar.VEOL2, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VSTART: {
                    attr.setControlChar(Attributes.ControlChar.VSTART, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VSTOP: {
                    attr.setControlChar(Attributes.ControlChar.VSTOP, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VSUSP: {
                    attr.setControlChar(Attributes.ControlChar.VSUSP, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VDSUSP: {
                    attr.setControlChar(Attributes.ControlChar.VDSUSP, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VREPRINT: {
                    attr.setControlChar(Attributes.ControlChar.VREPRINT, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VWERASE: {
                    attr.setControlChar(Attributes.ControlChar.VWERASE, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VLNEXT: {
                    attr.setControlChar(Attributes.ControlChar.VLNEXT, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VSTATUS: {
                    attr.setControlChar(Attributes.ControlChar.VSTATUS, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VDISCARD: {
                    attr.setControlChar(Attributes.ControlChar.VDISCARD, ((Integer)e.getValue()).intValue());
                    break;
                }
                case ECHO: {
                    attr.setLocalFlag(Attributes.LocalFlag.ECHO, (Integer)e.getValue() != 0);
                    break;
                }
                case ICANON: {
                    attr.setLocalFlag(Attributes.LocalFlag.ICANON, (Integer)e.getValue() != 0);
                    break;
                }
                case ISIG: {
                    attr.setLocalFlag(Attributes.LocalFlag.ISIG, (Integer)e.getValue() != 0);
                    break;
                }
                case ICRNL: {
                    attr.setInputFlag(Attributes.InputFlag.ICRNL, (Integer)e.getValue() != 0);
                    break;
                }
                case INLCR: {
                    attr.setInputFlag(Attributes.InputFlag.INLCR, (Integer)e.getValue() != 0);
                    break;
                }
                case IGNCR: {
                    attr.setInputFlag(Attributes.InputFlag.IGNCR, (Integer)e.getValue() != 0);
                    break;
                }
                case OCRNL: {
                    attr.setOutputFlag(Attributes.OutputFlag.OCRNL, (Integer)e.getValue() != 0);
                    break;
                }
                case ONLCR: {
                    attr.setOutputFlag(Attributes.OutputFlag.ONLCR, (Integer)e.getValue() != 0);
                    break;
                }
                case ONLRET: {
                    attr.setOutputFlag(Attributes.OutputFlag.ONLRET, (Integer)e.getValue() != 0);
                    break;
                }
                case OPOST: {
                    attr.setOutputFlag(Attributes.OutputFlag.OPOST, (Integer)e.getValue() != 0);
                }
            }
        }
        return attr;
    }
}

