/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;

public enum Eol {
    LF("\n"),
    CRLF("\r\n"),
    AUTODETECT(null){

        @Override
        public String getEolString() {
            throw new IllegalStateException("You need to autodetect the end of line value using " + Eol.class.getName() + ".autodetect(Path, Charset)");
        }
    }
    ,
    PLATFORM(null){

        @Override
        public String getEolString() {
            return System.getProperty("line.separator");
        }
    };

    private final String eolString;

    public static Eol autodetect(Path file, Charset charset) throws IOException {
        String content = new String(Files.readAllBytes(file), charset);
        return content.indexOf(13) >= 0 ? CRLF : LF;
    }

    private Eol(String eolString) {
        this.eolString = eolString;
    }

    public String getEolString() {
        return this.eolString;
    }
}

