/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.jikes;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.util.StreamPumper;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JikesCompiler
extends AbstractCompiler {
    private static final int OUTPUT_BUFFER_SIZE = 1024;

    public JikesCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public List<CompilerError> compile(CompilerConfiguration config) throws CompilerException {
        this.getDestinationDir(config);
        try {
            Process p = Runtime.getRuntime().exec(this.createCommandLine(config));
            BufferedInputStream compilerErr = new BufferedInputStream(p.getErrorStream());
            ByteArrayOutputStream tmpErr = new ByteArrayOutputStream(1024);
            StreamPumper errPumper = new StreamPumper(compilerErr, (OutputStream)tmpErr);
            errPumper.start();
            p.waitFor();
            int exitValue = p.exitValue();
            errPumper.join();
            compilerErr.close();
            p.destroy();
            tmpErr.close();
            BufferedReader input = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(tmpErr.toByteArray())));
            ArrayList<CompilerError> messages = new ArrayList<CompilerError>();
            this.parseStream(input, messages);
            if (exitValue != 0 && exitValue != 1) {
                messages.add(new CompilerError("Exit code from jikes was not 0 or 1 ->" + exitValue, true));
            }
            return messages;
        }
        catch (IOException e) {
            throw new CompilerException("Error while compiling.", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new CompilerException("Error while compiling.", (Throwable)e);
        }
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        ArrayList<String> args;
        block22: {
            String[] sourceFiles;
            block20: {
                args = new ArrayList<String>();
                args.add("jikes");
                String bootClassPath = JikesCompiler.getPathString(this.getBootClassPath());
                this.getLogger().debug("Bootclasspath: " + bootClassPath);
                if (!StringUtils.isEmpty((String)bootClassPath)) {
                    args.add("-bootclasspath");
                    args.add(bootClassPath);
                }
                String classPath = JikesCompiler.getPathString((List)config.getClasspathEntries());
                this.getLogger().debug("Classpath: " + classPath);
                if (!StringUtils.isEmpty((String)classPath)) {
                    args.add("-classpath");
                    args.add(classPath);
                }
                args.add("+E");
                if (config.getCustomCompilerArguments().size() > 0) {
                    for (Map.Entry arg : config.getCustomCompilerArgumentsAsMap().entrySet()) {
                        args.add((String)arg.getKey());
                        args.add((String)arg.getValue());
                    }
                }
                args.add("-target");
                if (StringUtils.isNotEmpty((String)config.getTargetVersion())) {
                    args.add(config.getTargetVersion());
                } else {
                    args.add("1.1");
                }
                args.add("-source");
                if (StringUtils.isNotEmpty((String)config.getSourceVersion())) {
                    args.add(config.getSourceVersion());
                } else {
                    args.add("1.3");
                }
                if (!config.isShowWarnings()) {
                    args.add("-nowarn");
                }
                if (config.isShowDeprecation()) {
                    args.add("-deprecation");
                }
                if (config.isOptimize()) {
                    args.add("-O");
                }
                if (config.isVerbose()) {
                    args.add("-verbose");
                }
                if (config.isDebug()) {
                    args.add("-g:lines");
                }
                args.add("-d");
                args.add(this.getDestinationDir(config).getAbsolutePath());
                String sourcePath = JikesCompiler.getPathString((List)config.getSourceLocations());
                this.getLogger().debug("Source path:" + sourcePath);
                if (!StringUtils.isEmpty((String)sourcePath)) {
                    args.add("-sourcepath");
                    args.add(sourcePath);
                }
                sourceFiles = JikesCompiler.getSourceFiles((CompilerConfiguration)config);
                if (!Os.isFamily((String)"windows")) break block20;
                String tempFileName = null;
                BufferedWriter fw = null;
                try {
                    File tempFile = File.createTempFile("compList", ".cmp");
                    tempFileName = tempFile.getAbsolutePath();
                    this.getLogger().debug("create TempFile" + tempFileName);
                    tempFile.getParentFile().mkdirs();
                    fw = new BufferedWriter(new FileWriter(tempFile));
                    for (int i = 0; i < sourceFiles.length; ++i) {
                        fw.write(sourceFiles[i]);
                        fw.newLine();
                    }
                    fw.flush();
                    tempFile.deleteOnExit();
                }
                catch (IOException e) {
                    try {
                        throw new CompilerException("Could not create temporary file " + tempFileName, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(fw);
                        throw throwable;
                    }
                }
                IOUtil.close((Writer)fw);
                args.add("@" + tempFileName);
                break block22;
            }
            for (int i = 0; i < sourceFiles.length; ++i) {
                args.add(sourceFiles[i]);
            }
        }
        return args.toArray(new String[args.size()]);
    }

    private File getDestinationDir(CompilerConfiguration config) {
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        return destinationDir;
    }

    private List<String> getBootClassPath() {
        File javaExtDir;
        File javaClassesDir;
        ArrayList<String> bootClassPath = new ArrayList<String>();
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                String name = file.getName();
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        };
        File javaHomeDir = new File(System.getProperty("java.home"));
        File javaLibDir = new File(javaHomeDir, "lib");
        if (javaLibDir.isDirectory()) {
            bootClassPath.addAll(this.asList(javaLibDir.listFiles(filter)));
        }
        if ((javaClassesDir = new File(javaHomeDir, "../Classes")).isDirectory()) {
            bootClassPath.addAll(this.asList(javaClassesDir.listFiles(filter)));
        }
        if ((javaExtDir = new File(javaLibDir, "ext")).isDirectory()) {
            bootClassPath.addAll(this.asList(javaExtDir.listFiles(filter)));
        }
        return bootClassPath;
    }

    private List<String> asList(File[] files) {
        ArrayList<String> filenames = new ArrayList<String>(files.length);
        for (File file : files) {
            filenames.add(file.toString());
        }
        return filenames;
    }

    protected List<CompilerError> parseStream(BufferedReader input, List<CompilerError> messages) throws IOException {
        String line = null;
        while (true) {
            StringBuilder buffer = new StringBuilder();
            if (line == null) {
                line = input.readLine();
            }
            if (line == null) {
                return messages;
            }
            buffer.append(line);
            while ((line = input.readLine()) != null && (line.length() <= 0 || line.charAt(0) == ' ')) {
                buffer.append(EOL);
                buffer.append(line);
            }
            if (buffer.length() <= 0) continue;
            messages.add(this.parseError(buffer.toString()));
        }
    }

    private CompilerError parseError(String error) {
        int i;
        String file;
        if (error.startsWith("Error:")) {
            return new CompilerError(error, true);
        }
        String[] errorBits = StringUtils.split((String)error, (String)":");
        if (Os.isFamily((String)"windows")) {
            file = errorBits[0] + ':' + errorBits[1];
            i = 2;
        } else {
            file = errorBits[0];
            i = 1;
        }
        int startline = Integer.parseInt(errorBits[i++]);
        int startcolumn = Integer.parseInt(errorBits[i++]);
        int endline = Integer.parseInt(errorBits[i++]);
        int endcolumn = Integer.parseInt(errorBits[i++]);
        String type = errorBits[i++];
        StringBuilder message = new StringBuilder(errorBits[i++]);
        while (i < errorBits.length) {
            message.append(':').append(errorBits[i++]);
        }
        return new CompilerError(file, type.indexOf("Error") > -1, startline, startcolumn, endline, endcolumn, message.toString());
    }
}

