/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codehaus.stomp;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.codehaus.stomp.jms.StompConnect;

/**
 * A Stomp Broker using StompConnect and Apache ActiveMQ
 *
 * @version $Revision: 52 $
 */
public class ActiveMQStompConnect {
    public static void main(String[] args) {
        try {
            StompConnect connect = new StompConnect();
            String url = "vm://localhost?broker.persistent=false&broker.useJmx=false";
            if (args.length > 0) {
                url = args[0];
            }
            connect.setConnectionFactory(new ActiveMQConnectionFactory(url));
            connect.start();
            connect.join();
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }
}
