/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stomp.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ServerSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.stomp.StompHandler;
import org.codehaus.stomp.StompHandlerFactory;
import org.codehaus.stomp.tcp.TcpTransport;
import org.codehaus.stomp.util.IOExceptionSupport;
import org.codehaus.stomp.util.ServiceSupport;

public class TcpTransportServer
extends ServiceSupport
implements Runnable {
    private static final Log log = LogFactory.getLog(TcpTransportServer.class);
    private StompHandlerFactory stompHandlerFactory;
    private ServerSocket serverSocket;
    private int backlog = 5000;
    private boolean trace;
    private Map transportOptions;
    private ServerSocketFactory serverSocketFactory;
    private boolean daemon = true;
    private boolean joinOnStop = true;
    private Thread runner;
    private URI connectURI;
    private URI bindLocation;
    private List<TcpTransport> connections = new CopyOnWriteArrayList<TcpTransport>();

    public TcpTransportServer(StompHandlerFactory stompHandlerFactory, URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        this.stompHandlerFactory = stompHandlerFactory;
        this.connectURI = location;
        this.bindLocation = location;
        this.serverSocketFactory = serverSocketFactory;
    }

    public String toString() {
        return "" + this.getBindLocation();
    }

    public void run() {
        while (!this.isStopped()) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                if (socket == null) continue;
                if (this.isStopped()) {
                    socket.close();
                    continue;
                }
                TcpTransport transport = this.createTransport(socket);
                this.connectHandlers(transport);
                transport.start();
                this.connections.add(transport);
            }
            catch (SocketTimeoutException transport) {
            }
            catch (Exception e) {
                if (this.isStopping() || this.isStopped()) continue;
                this.onAcceptError(e);
            }
        }
    }

    public void join() throws InterruptedException {
        this.runner.join();
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean isJoinOnStop() {
        return this.joinOnStop;
    }

    public void setJoinOnStop(boolean joinOnStop) {
        this.joinOnStop = joinOnStop;
    }

    public URI getConnectURI() {
        return this.connectURI;
    }

    public void setConnectURI(URI location) {
        this.connectURI = location;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public URI getBindLocation() {
        return this.bindLocation;
    }

    public void setBindLocation(URI bindLocation) {
        this.bindLocation = bindLocation;
    }

    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.serverSocket.getLocalSocketAddress();
    }

    public void setTransportOption(Map transportOptions) {
        this.transportOptions = transportOptions;
    }

    protected void doStart() throws Exception {
        this.bind();
        log.info((Object)("Listening for connections at: " + this.getConnectURI()));
        this.runner = new Thread((Runnable)this, "StompConnect Server Thread: " + this.toString());
        this.runner.setDaemon(this.daemon);
        this.runner.start();
    }

    protected void doStop() throws Exception {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        try {
            for (TcpTransport connection : this.connections) {
                connection.stop();
            }
        }
        finally {
            this.connections.clear();
        }
        if (this.runner != null && this.joinOnStop) {
            this.join();
            this.runner = null;
        }
    }

    protected void bind() throws IOException {
        URI bind = this.getBindLocation();
        String host = bind.getHost();
        host = host == null || host.length() == 0 ? "localhost" : host;
        InetAddress addr = InetAddress.getByName(host);
        try {
            this.serverSocket = host.trim().equals("localhost") || addr.equals(InetAddress.getLocalHost()) ? this.serverSocketFactory.createServerSocket(bind.getPort(), this.backlog) : this.serverSocketFactory.createServerSocket(bind.getPort(), this.backlog, addr);
            this.serverSocket.setSoTimeout(2000);
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Failed to bind to server socket: " + bind + " due to: " + e, e);
        }
        try {
            this.setConnectURI(new URI(bind.getScheme(), bind.getUserInfo(), this.resolveHostName(bind.getHost()), this.serverSocket.getLocalPort(), bind.getPath(), bind.getQuery(), bind.getFragment()));
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create(e);
        }
    }

    protected void connectHandlers(TcpTransport transport) throws Exception {
        StompHandler inputHandler = this.stompHandlerFactory.createStompHandler(transport);
        transport.setInputHandler(inputHandler);
    }

    protected void onAcceptError(Exception e) {
        log.error((Object)("Received accept error: " + e), (Throwable)e);
        try {
            this.stop();
        }
        catch (Exception e1) {
            log.error((Object)("Failed to shut down: " + e), (Throwable)e);
        }
    }

    protected TcpTransport createTransport(Socket socket) throws IOException {
        return new TcpTransport(socket, this.transportOptions);
    }

    protected String resolveHostName(String hostName) throws UnknownHostException {
        String result = hostName;
        if (hostName != null && (hostName.equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1"))) {
            result = InetAddress.getLocalHost().getHostName();
        }
        return result;
    }
}

