/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stomp.jms;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.stomp.ProtocolException;
import org.codehaus.stomp.StompFrame;
import org.codehaus.stomp.jms.StompSession;

public class StompSubscription
implements MessageListener {
    public static final String AUTO_ACK = "auto";
    public static final String CLIENT_ACK = "client";
    private static final transient Log log = LogFactory.getLog(StompSubscription.class);
    private final StompSession session;
    private final String subscriptionId;
    private Destination destination;
    private MessageConsumer consumer;

    public StompSubscription(StompSession session, String subscriptionId, StompFrame frame) throws JMSException, ProtocolException {
        this.subscriptionId = subscriptionId;
        this.session = session;
        Map<String, Object> headers = frame.getHeaders();
        String selector = (String)headers.remove("selector");
        String destinationName = (String)headers.get("destination");
        this.destination = session.convertDestination(destinationName, true);
        Session jmsSession = session.getSession();
        boolean noLocal = false;
        if (this.destination instanceof Topic) {
            String subscriberName;
            String value = (String)headers.get("no-local");
            if (value != null && "true".equalsIgnoreCase(value)) {
                noLocal = true;
            }
            this.consumer = (subscriberName = (String)headers.get("durable-subscription-name")) != null ? jmsSession.createDurableSubscriber((Topic)this.destination, subscriberName, selector, noLocal) : jmsSession.createConsumer(this.destination, selector, noLocal);
        } else {
            this.consumer = jmsSession.createConsumer(this.destination, selector);
        }
        this.consumer.setMessageListener((MessageListener)this);
    }

    public void close() throws JMSException {
        this.consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block6: {
            log.debug((Object)"onMessage3");
            try {
                int ackMode = this.session.getSession().getAcknowledgeMode();
                if (ackMode != 2) break block6;
                MessageConsumer messageConsumer = this.consumer;
                synchronized (messageConsumer) {
                    boolean closing = this.session.getProtocolConverter().addMessageToAck(message, this.consumer);
                    if (!closing) {
                        this.session.sendToStomp(message, this);
                        this.consumer.wait();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to process message due to: " + e + ". Message: " + message), (Throwable)e);
            }
        }
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public Destination getDestination() {
        return this.destination;
    }
}

