/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stomp.util;

import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ServiceSupport {
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean stopping = new AtomicBoolean(false);
    private AtomicBoolean stopped = new AtomicBoolean(false);

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.doStart();
        }
    }

    public void stop() throws Exception {
        if (this.stopped.compareAndSet(false, true)) {
            this.stopping.set(true);
            try {
                this.doStop();
            }
            finally {
                this.stopped.set(true);
                this.started.set(false);
                this.stopping.set(false);
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    protected abstract void doStop() throws Exception;

    protected abstract void doStart() throws Exception;
}

