/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stomp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.stomp.ProtocolException;
import org.codehaus.stomp.StompFrame;
import org.codehaus.stomp.StompFrameError;

public class StompMarshaller {
    private static final byte[] NO_DATA = new byte[0];
    private static final byte[] END_OF_FRAME = new byte[]{0, 10};
    private static final int MAX_COMMAND_LENGTH = 1024;
    private static final int MAX_HEADER_LENGTH = 10240;
    private static final int MAX_HEADERS = 1000;
    private static final int MAX_DATA_LENGTH = 0x6400000;
    private int version = 1;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public byte[] marshal(StompFrame command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.marshal(command, dos);
        dos.close();
        return baos.toByteArray();
    }

    public Object unmarshal(byte[] packet) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(packet);
        DataInputStream dis = new DataInputStream(stream);
        return this.unmarshal(dis);
    }

    public void marshal(StompFrame stomp, DataOutput os) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(stomp.getAction());
        buffer.append("\n");
        for (Map.Entry<String, Object> entry : stomp.getHeaders().entrySet()) {
            buffer.append((Object)entry.getKey());
            buffer.append(":");
            buffer.append(entry.getValue());
            buffer.append("\n");
        }
        buffer.append("\n");
        os.write(buffer.toString().getBytes("UTF-8"));
        os.write(stomp.getContent());
        os.write(END_OF_FRAME);
    }

    public StompFrame unmarshal(DataInput in) throws IOException {
        try {
            String line;
            String action = null;
            do {
                if ((action = this.readLine(in, 1024, "The maximum command length was exceeded")) != null) continue;
                throw new IOException("connection was closed");
            } while ((action = action.trim()).length() <= 0);
            HashMap<String, Object> headers = new HashMap<String, Object>(25);
            while ((line = this.readLine(in, 10240, "The maximum header length was exceeded")) != null && line.trim().length() > 0) {
                if (headers.size() > 1000) {
                    throw new ProtocolException("The maximum number of headers was exceeded", true);
                }
                try {
                    int seperator_index = line.indexOf(":");
                    String name = line.substring(0, seperator_index).trim();
                    String value = line.substring(seperator_index + 1, line.length()).trim();
                    headers.put(name, value);
                }
                catch (Exception e) {
                    throw new ProtocolException("Unable to parser header line [" + line + "]", true);
                }
            }
            byte[] data = NO_DATA;
            String contentLength = (String)headers.get("content-length");
            if (contentLength != null) {
                int length;
                try {
                    length = Integer.parseInt(contentLength.trim());
                }
                catch (NumberFormatException e) {
                    throw new ProtocolException("Specified content-length is not a valid integer", true);
                }
                if (length > 0x6400000) {
                    throw new ProtocolException("The maximum data length was exceeded", true);
                }
                data = new byte[length];
                in.readFully(data);
                if (in.readByte() != 0) {
                    throw new ProtocolException("content-length bytes were read and there was no trailing null byte", true);
                }
            } else {
                byte b;
                ByteArrayOutputStream baos = null;
                while ((b = in.readByte()) != 0) {
                    if (baos == null) {
                        baos = new ByteArrayOutputStream();
                    } else if (baos.size() > 0x6400000) {
                        throw new ProtocolException("The maximum data length was exceeded", true);
                    }
                    baos.write(b);
                }
                if (baos != null) {
                    baos.close();
                    data = baos.toByteArray();
                }
            }
            return new StompFrame(action, headers, data);
        }
        catch (ProtocolException e) {
            return new StompFrameError(e);
        }
    }

    protected String readLine(DataInput in, int maxLength, String errorMessage) throws IOException {
        byte b;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(maxLength);
        while ((b = in.readByte()) != 10) {
            if (baos.size() > maxLength) {
                throw new ProtocolException(errorMessage, true);
            }
            baos.write(b);
        }
        byte[] sequence = baos.toByteArray();
        return new String(sequence, "UTF-8");
    }
}

