/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stomp.jms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.stomp.ProtocolException;
import org.codehaus.stomp.Stomp;
import org.codehaus.stomp.StompFrame;
import org.codehaus.stomp.jms.ProtocolConverter;
import org.codehaus.stomp.jms.StompSubscription;

public class StompSession {
    private final ProtocolConverter protocolConverter;
    private final Session session;
    private MessageProducer producer;
    private static Map<String, Destination> temporaryDestinations = new HashMap<String, Destination>();
    private List<String> created = new ArrayList<String>();
    private static final Log log = LogFactory.getLog(StompSession.class);

    public StompSession(ProtocolConverter protocolConverter, Session session) {
        this.protocolConverter = protocolConverter;
        this.session = session;
    }

    public ProtocolConverter getProtocolConverter() {
        return this.protocolConverter;
    }

    public Session getSession() {
        return this.session;
    }

    public MessageProducer getProducer() throws JMSException {
        if (this.producer == null) {
            this.producer = this.session.createProducer(null);
        }
        return this.producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        this.session.close();
        Map<String, Destination> map = temporaryDestinations;
        synchronized (map) {
            Iterator<String> i = this.created.iterator();
            while (i.hasNext()) {
                temporaryDestinations.remove(i.next());
            }
        }
    }

    public void sendToJms(StompFrame command) throws JMSException, ProtocolException {
        Map<String, Object> headers = command.getHeaders();
        String destinationName = (String)headers.remove("destination");
        Message message = this.convertFrame(command);
        Destination destination = this.convertDestination(destinationName, false);
        int deliveryMode = this.getDeliveryMode(headers);
        int priority = this.getPriority(headers);
        long timeToLive = this.getTimeToLive(headers);
        this.getProducer().send(destination, message, deliveryMode, priority, timeToLive);
    }

    public void sendToStomp(Message message, StompSubscription subscription) throws Exception {
        log.debug((Object)"Sending to stomp");
        StompFrame frame = this.convertMessage(message);
        frame.getHeaders().put("subscription", subscription.getSubscriptionId());
        this.protocolConverter.sendToStomp(frame);
    }

    public Destination convertDestination(String name, boolean forceNew) throws ProtocolException, JMSException {
        if (name == null) {
            throw new ProtocolException("No destination is specified!");
        }
        if (name.startsWith("/queue/")) {
            String queueName = name.substring("/queue/".length(), name.length());
            return this.session.createQueue(queueName);
        }
        if (name.startsWith("/topic/")) {
            String topicName = name.substring("/topic/".length(), name.length());
            return this.session.createTopic(topicName);
        }
        if (name.startsWith("/temp-queue/")) {
            String tempName = name.substring("/temp-queue/".length(), name.length());
            Destination answer = temporaryDestinations.get(tempName);
            if (forceNew || answer == null) {
                return this.temporaryDestination(tempName, (Destination)this.session.createTemporaryQueue());
            }
            return answer;
        }
        if (name.startsWith("/temp-topic/")) {
            String tempName = name.substring("/temp-topic/".length(), name.length());
            Destination answer = temporaryDestinations.get(tempName);
            if (forceNew || answer == null) {
                return this.temporaryDestination(tempName, (Destination)this.session.createTemporaryTopic());
            }
            return answer;
        }
        throw new ProtocolException("Illegal destination name: [" + name + "] -- StompConnect destinations " + "must begine with one of: /queue/ /topic/ /temp-queue/ /temp-topic/");
    }

    protected String convertDestination(Destination d) throws JMSException {
        if (d == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        if (d instanceof Topic) {
            Topic topic = (Topic)d;
            if (d instanceof TemporaryTopic) {
                buffer.append("/temp-topic/");
                this.temporaryDestination(topic.getTopicName(), d);
            } else {
                buffer.append("/topic/");
            }
            buffer.append(topic.getTopicName());
        } else {
            Queue queue = (Queue)d;
            if (d instanceof TemporaryQueue) {
                buffer.append("/temp-queue/");
                this.temporaryDestination(queue.getQueueName(), d);
            } else {
                buffer.append("/queue/");
            }
            buffer.append(queue.getQueueName());
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Destination temporaryDestination(String tempName, Destination temporaryDestination) {
        Map<String, Destination> map = temporaryDestinations;
        synchronized (map) {
            temporaryDestinations.put(tempName, temporaryDestination);
            this.created.add(tempName);
        }
        return temporaryDestination;
    }

    protected int getDeliveryMode(Map headers) throws JMSException {
        Object o = headers.remove(Stomp.Headers.Send.PERSISTENT);
        if (o != null) {
            return "true".equals(o) ? 2 : 1;
        }
        return this.getProducer().getDeliveryMode();
    }

    protected int getPriority(Map headers) throws JMSException {
        Object o = headers.remove("priority");
        if (o != null) {
            return Integer.parseInt((String)o);
        }
        return this.getProducer().getPriority();
    }

    protected long getTimeToLive(Map headers) throws JMSException {
        Object o = headers.remove("expires");
        if (o != null) {
            return Long.parseLong((String)o);
        }
        return this.getProducer().getTimeToLive();
    }

    protected void copyStandardHeadersFromMessageToFrame(Message message, StompFrame command) throws IOException, JMSException {
        Map<String, Object> headers = command.getHeaders();
        headers.put("destination", this.convertDestination(message.getJMSDestination()));
        headers.put("message-id", message.getJMSMessageID());
        if (message.getJMSCorrelationID() != null) {
            headers.put("correlation-id", message.getJMSCorrelationID());
        }
        headers.put("expires", "" + message.getJMSExpiration());
        if (message.getJMSRedelivered()) {
            headers.put("redelivered", "true");
        }
        headers.put("priority", "" + message.getJMSPriority());
        if (message.getJMSReplyTo() != null) {
            headers.put("reply-to", this.convertDestination(message.getJMSReplyTo()));
        }
        headers.put("timestamp", "" + message.getJMSTimestamp());
        if (message.getJMSType() != null) {
            headers.put("type", message.getJMSType());
        }
        Enumeration names = message.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = message.getObjectProperty(name);
            headers.put(name, value);
        }
    }

    protected void copyStandardHeadersFromFrameToMessage(StompFrame command, Message msg) throws JMSException, ProtocolException {
        HashMap<String, Object> headers = new HashMap<String, Object>(command.getHeaders());
        msg.setJMSCorrelationID((String)headers.remove("correlation-id"));
        Object o = headers.remove("type");
        if (o != null) {
            msg.setJMSType((String)o);
        }
        if ((o = headers.remove("reply-to")) != null) {
            msg.setJMSReplyTo(this.convertDestination((String)o, false));
        }
        for (Map.Entry entry : headers.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            msg.setObjectProperty(name, value);
        }
    }

    protected Message convertFrame(StompFrame command) throws JMSException, ProtocolException {
        BytesMessage msg;
        Map<String, Object> headers = command.getHeaders();
        if (headers.containsKey("content-length")) {
            headers.remove("content-length");
            BytesMessage bm = this.session.createBytesMessage();
            bm.writeBytes(command.getContent());
            msg = bm;
        } else {
            String text;
            try {
                text = new String(command.getContent(), "UTF-8");
            }
            catch (Throwable e) {
                throw new ProtocolException("Text could not bet set: " + e, false, e);
            }
            msg = this.session.createTextMessage(text);
        }
        this.copyStandardHeadersFromFrameToMessage(command, (Message)msg);
        return msg;
    }

    protected StompFrame convertMessage(Message message) throws IOException, JMSException {
        StompFrame command = new StompFrame();
        command.setAction("MESSAGE");
        HashMap<String, Object> headers = new HashMap<String, Object>(25);
        command.setHeaders(headers);
        this.copyStandardHeadersFromMessageToFrame(message, command);
        if (message instanceof TextMessage) {
            TextMessage msg = (TextMessage)message;
            command.setContent(msg.getText().getBytes("UTF-8"));
        } else if (message instanceof BytesMessage) {
            BytesMessage msg = (BytesMessage)message;
            byte[] data = new byte[(int)msg.getBodyLength()];
            msg.readBytes(data);
            headers.put("content-length", "" + data.length);
            command.setContent(data);
        }
        return command;
    }
}

