/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stomp.tcp;

import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TcpBufferedOutputStream
extends FilterOutputStream {
    private static final int BUFFER_SIZE = 8192;
    private byte[] buffer;
    private int bufferlen;
    private int count;
    private boolean closed;

    public TcpBufferedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public TcpBufferedOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buffer = new byte[size];
        this.bufferlen = size;
    }

    public void write(int b) throws IOException {
        if (this.bufferlen - this.count < 1) {
            this.flush();
        }
        this.buffer[this.count++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bufferlen - this.count < len) {
            this.flush();
        }
        if (this.buffer.length >= len) {
            System.arraycopy(b, off, this.buffer, this.count, len);
            this.count += len;
        } else {
            this.out.write(b, off, len);
        }
    }

    public void flush() throws IOException {
        if (this.count > 0 && this.out != null) {
            this.out.write(this.buffer, 0, this.count);
            this.count = 0;
        }
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    private final void checkClosed() throws IOException {
        if (this.closed) {
            throw new EOFException("Cannot write to the stream any more it has already been closed");
        }
    }
}

