/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests;

import java.io.File;
import java.io.IOException;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.FileManager;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.camel.container.integration.tests.AbstractKieCamelIntegrationTest;
import org.kie.scanner.KieMavenRepository;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;

public class RemoteIntegrationTest
extends AbstractKieCamelIntegrationTest {
    @Test
    public void listContainersTest() throws Exception {
        String containerId = "test-container";
        org.kie.server.api.model.ReleaseId releaseId = new org.kie.server.api.model.ReleaseId("org.drools", "camel-container-tests-kjar", "1.0");
        this.createKieJar(releaseId);
        KieContainerResource kieContainerResource = new KieContainerResource(releaseId);
        kieContainerResource.setContainerId("test-container");
        KieContainerResource resource = this.kieCamelTestService.esCreateContainer("test-container", kieContainerResource);
        Assertions.assertThat((Object)resource).isNotNull();
        KieContainerResourceList kieContainerResourceList = this.kieCamelTestService.esListContainers();
        Assertions.assertThat((int)kieContainerResourceList.getContainers().size()).isGreaterThan(0);
    }

    private void createKieJar(org.kie.server.api.model.ReleaseId releaseId) throws IOException {
        KieServices ks = KieServices.get();
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false);
        kfs.writePomXML(this.getPom((ReleaseId)releaseId));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((String)"", (boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        InternalKieModule kJar1 = (InternalKieModule)kieBuilder.getKieModule();
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, this.createKPom((ReleaseId)releaseId));
    }

    private KieFileSystem createKieFileSystemWithKProject(KieServices ks, boolean isdefault) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    private File createKPom(ReleaseId releaseId) throws IOException {
        FileManager fileManager = new FileManager();
        fileManager.setUp();
        File pomFile = fileManager.newFile("pom.xml");
        fileManager.write(pomFile, this.getPom(releaseId));
        return pomFile;
    }

    private String getPom(ReleaseId releaseId) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n</project>";
    }
}

