/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests.remote;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.camel.container.api.ExecutionServerCommand;
import org.kie.camel.container.integration.tests.remote.AbstractRemoteIntegrationTest;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.QueryDefinition;

public class QueryClientIntegrationTest
extends AbstractRemoteIntegrationTest {
    @Test
    public void testFindProcessesById() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processId", "process1");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("findProcessesById");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        List processDefinitions = (List)response;
        Assertions.assertThat((List)processDefinitions).isNotEmpty();
        List processIds = processDefinitions.stream().map(p -> p.getId()).collect(Collectors.toList());
        Assertions.assertThat(processIds).contains((Object[])new String[]{"process1"});
    }

    @Test
    public void testFindProcesses() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("page", "0");
        parameters.put("pageSize", "10");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("findProcesses");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        List processDefinitions = (List)response;
        Assertions.assertThat((List)processDefinitions).isNotEmpty();
        List processIds = processDefinitions.stream().map(p -> p.getId()).collect(Collectors.toList());
        Assertions.assertThat(processIds).contains((Object[])new String[]{"process1"});
    }

    @Test
    public void testFindProcessesByContainerId() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", "test-container");
        parameters.put("page", "0");
        parameters.put("pageSize", "10");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("findProcessesByContainerId");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        List processDefinitions = (List)response;
        Assertions.assertThat((List)processDefinitions).isNotEmpty();
        List processIds = processDefinitions.stream().map(p -> p.getId()).collect(Collectors.toList());
        Assertions.assertThat(processIds).contains((Object[])new String[]{"process1"});
    }

    @Test
    public void testFindProcessesByContainerIdWrongId() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", "wrong-container-id");
        parameters.put("page", "0");
        parameters.put("pageSize", "10");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("findProcessesByContainerId");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        List processDefinitions = (List)response;
        Assertions.assertThat((List)processDefinitions).isEmpty();
    }

    @Test
    public void testFindProcessByContainerIdProcessId() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", "test-container");
        parameters.put("processId", "process1");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("findProcessByContainerIdProcessId");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(ProcessDefinition.class);
        ProcessDefinition processDefinition = (ProcessDefinition)response;
        Assertions.assertThat((String)processDefinition.getContainerId()).isEqualTo("test-container");
        Assertions.assertThat((String)processDefinition.getId()).isEqualTo("process1");
    }

    @Test
    public void testFindProcessInstances() {
        Long processInstanceId = this.startProcess("test-container", "processWithSignal");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("page", "0");
        parameters.put("pageSize", "10");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("findProcessInstances");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        List processInstances = (List)response;
        Assertions.assertThat((List)processInstances).isNotEmpty();
        List processInstancesIds = processInstances.stream().map(p -> p.getId()).collect(Collectors.toList());
        Assertions.assertThat(processInstancesIds).contains((Object[])new Long[]{processInstanceId});
        this.sendSignalToProcessInstance("test-container", processInstanceId, "signal1");
    }

    @Test
    public void testFindProcessInstancesByContainerId() {
        Long processInstanceId = this.startProcess("test-container", "processWithSignal");
        List<Integer> statuses = Arrays.asList(1);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("containerId", "test-container");
        parameters.put("page", "0");
        parameters.put("pageSize", "10");
        parameters.put("status", statuses);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("findProcessInstancesByContainerId");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        List processInstances = (List)response;
        Assertions.assertThat((List)processInstances).isNotEmpty();
        List processInstancesIds = processInstances.stream().map(p -> p.getId()).collect(Collectors.toList());
        Assertions.assertThat(processInstancesIds).contains((Object[])new Long[]{processInstanceId});
        this.sendSignalToProcessInstance("test-container", processInstanceId, "signal1");
    }

    @Test
    public void testFindProcessInstancesByStatus() {
        Long processInstanceId = this.startProcess("test-container", "processWithSignal");
        List<Integer> statuses = Arrays.asList(1);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("status", statuses);
        parameters.put("page", "0");
        parameters.put("pageSize", "10");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("findProcessInstancesByStatus");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        List processInstances = (List)response;
        Assertions.assertThat((List)processInstances).isNotEmpty();
        List processInstancesIds = processInstances.stream().map(p -> p.getId()).collect(Collectors.toList());
        Assertions.assertThat(processInstancesIds).contains((Object[])new Long[]{processInstanceId});
        this.sendSignalToProcessInstance("test-container", processInstanceId, "signal1");
    }

    @Test
    public void testFindProcessInstanceByInitiator() {
        Long processInstanceId = this.startProcess("test-container", "processWithSignal");
        List<Integer> statuses = Arrays.asList(1);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("initiator", "yoda");
        parameters.put("status", statuses);
        parameters.put("page", "0");
        parameters.put("pageSize", "10");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("findProcessInstancesByInitiator");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        List processInstances = (List)response;
        Assertions.assertThat((List)processInstances).isNotEmpty();
        List processInstancesIds = processInstances.stream().map(p -> p.getId()).collect(Collectors.toList());
        Assertions.assertThat(processInstancesIds).contains((Object[])new Long[]{processInstanceId});
        this.sendSignalToProcessInstance("test-container", processInstanceId, "signal1");
    }

    @Test
    public void testListQueries() {
        this.registerQuery(QueryClientIntegrationTest.getSimpleQueryDefinition());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("page", 0);
        parameters.put("pageSize", 10);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("getQueries");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        List queryDefinitionList = (List)response;
        Assertions.assertThat((List)queryDefinitionList).isNotEmpty();
        List queryNames = queryDefinitionList.stream().map(q -> q.getName()).collect(Collectors.toList());
        Assertions.assertThat(queryNames).contains((Object[])new String[]{"process-instances-query"});
        this.unregisterQuery("process-instances-query");
    }

    private static final QueryDefinition getSimpleQueryDefinition() {
        QueryDefinition simpleQueryDefinition = new QueryDefinition();
        simpleQueryDefinition.setName("process-instances-query");
        simpleQueryDefinition.setExpression("select * from ProcessInstanceLog");
        simpleQueryDefinition.setTarget("PROCESS");
        simpleQueryDefinition.setSource("java:jboss/datasources/ExampleDS");
        return simpleQueryDefinition;
    }

    private QueryDefinition registerQuery(QueryDefinition queryDefinition) {
        HashMap<String, QueryDefinition> parameters = new HashMap<String, QueryDefinition>();
        parameters.put("queryDefinition", queryDefinition);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("registerQuery");
        executionServerCommand.setParameters(parameters);
        Object object = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)object).isNotNull();
        Assertions.assertThat((Object)object).isInstanceOf(QueryDefinition.class);
        QueryDefinition response = (QueryDefinition)object;
        return response;
    }

    private void unregisterQuery(String queryName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("queryName", queryName);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("unregisterQuery");
        executionServerCommand.setParameters(parameters);
        this.runOnExecutionServer(executionServerCommand);
    }
}

