/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests.remote;

import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.camel.container.api.ExecutionServerCommand;
import org.kie.camel.container.integration.tests.remote.AbstractRemoteIntegrationTest;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskSummary;

public class UserTaskClientIntegrationTest
extends AbstractRemoteIntegrationTest {
    private static final String INITIAL_PROCESS_VARIABLE_VALUE = "initial-value";
    private static final String NEW_PROCESS_VARIABLE_VALUE = "new-value";

    @Test
    public void testFindTaskById() {
        HashMap<String, Object> initialProcessVariables = new HashMap<String, Object>();
        initialProcessVariables.put("var1", "initialValue");
        long processInstanceId = this.startProcess("test-container", "processWithHumanTask", initialProcessVariables);
        Assertions.assertThat((long)processInstanceId).isPositive();
        List<TaskSummary> allTasks = this.listTaskInstancesAsPotentialOwner();
        Assertions.assertThat(allTasks).isNotEmpty();
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("taskId", allTasks.get(0).getId());
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("userTask");
        executionServerCommand.setOperation("findTaskById");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(TaskInstance.class);
        TaskInstance taskInstance = (TaskInstance)response;
        Assertions.assertThat((Long)taskInstance.getId()).isEqualTo((Object)allTasks.get(0).getId());
    }

    @Test
    public void testTaskWorkflow() {
        HashMap<String, Object> initialProcessVariables = new HashMap<String, Object>();
        initialProcessVariables.put("var1", INITIAL_PROCESS_VARIABLE_VALUE);
        long processInstanceId = this.startProcess("test-container", "processWithHumanTask", initialProcessVariables);
        Assertions.assertThat((long)processInstanceId).isPositive();
        Assertions.assertThat((String)this.getProcessVariables("test-container", processInstanceId).get("var1")).isEqualTo(INITIAL_PROCESS_VARIABLE_VALUE);
        List<TaskSummary> taskInstances = this.listTaskInstancesAsPotentialOwner();
        Assertions.assertThat(taskInstances).hasSize(1);
        long taskId = taskInstances.get(0).getId();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("containerId", "test-container");
        parameters.put("taskId", taskId);
        parameters.put("userId", "yoda");
        ExecutionServerCommand claimTaskCommand = new ExecutionServerCommand();
        claimTaskCommand.setClient("userTask");
        claimTaskCommand.setOperation("claimTask");
        claimTaskCommand.setParameters(parameters);
        this.runOnExecutionServer(claimTaskCommand);
        ExecutionServerCommand startTaskCommand = new ExecutionServerCommand();
        startTaskCommand.setClient("userTask");
        startTaskCommand.setOperation("startTask");
        startTaskCommand.setParameters(parameters);
        this.runOnExecutionServer(startTaskCommand);
        HashMap<String, String> taskParameters = new HashMap<String, String>();
        taskParameters.put("var1", NEW_PROCESS_VARIABLE_VALUE);
        parameters.put("params", taskParameters);
        ExecutionServerCommand completeTaskCommand = new ExecutionServerCommand();
        completeTaskCommand.setClient("userTask");
        completeTaskCommand.setOperation("completeTask");
        completeTaskCommand.setParameters(parameters);
        this.runOnExecutionServer(completeTaskCommand);
        Assertions.assertThat((String)this.getProcessVariables("test-container", processInstanceId).get("var1")).isEqualTo(NEW_PROCESS_VARIABLE_VALUE);
        this.sendSignalToProcessInstance("test-container", processInstanceId, "signal1");
    }

    @Test
    public void testCompleteAutoProgress() {
        HashMap<String, Object> initialProcessVariables = new HashMap<String, Object>();
        initialProcessVariables.put("var1", INITIAL_PROCESS_VARIABLE_VALUE);
        long processInstanceId = this.startProcess("test-container", "processWithHumanTask", initialProcessVariables);
        Assertions.assertThat((long)processInstanceId).isPositive();
        Assertions.assertThat((String)this.getProcessVariables("test-container", processInstanceId).get("var1")).isEqualTo(INITIAL_PROCESS_VARIABLE_VALUE);
        List<TaskSummary> taskInstances = this.listTaskInstancesAsPotentialOwner();
        Assertions.assertThat(taskInstances).hasSize(1);
        long taskId = taskInstances.get(0).getId();
        HashMap<String, String> taskParameters = new HashMap<String, String>();
        taskParameters.put("var1", NEW_PROCESS_VARIABLE_VALUE);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("containerId", "test-container");
        parameters.put("taskId", taskId);
        parameters.put("userId", "yoda");
        parameters.put("params", taskParameters);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("userTask");
        executionServerCommand.setOperation("completeAutoProgress");
        executionServerCommand.setParameters(parameters);
        this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((String)this.getProcessVariables("test-container", processInstanceId).get("var1")).isEqualTo(NEW_PROCESS_VARIABLE_VALUE);
        this.sendSignalToProcessInstance("test-container", processInstanceId, "signal1");
    }

    private List<TaskSummary> listTaskInstancesAsPotentialOwner() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", "yoda");
        parameters.put("page", "0");
        parameters.put("pageSize", "10");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("userTask");
        executionServerCommand.setOperation("findTasksAssignedAsPotentialOwner");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        List taskInstances = (List)response;
        return taskInstances;
    }
}

