/*
 * Decompiled with CFR 0.152.
 */
package org.drools.example.cdi.scopes;

import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.drools.example.cdi.scopes.MyBean;
import org.drools.example.cdi.scopes.MyRequestScopedBean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class RequestScopedRulesJUnitTest {
    @Inject
    private MyRequestScopedBean myRequestBean;
    private ContextControl ctxCtrl = (ContextControl)BeanProvider.getContextualReference(ContextControl.class, (Annotation[])new Annotation[0]);

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{MyBean.class, MyRequestScopedBean.class})).addPackages(true, new String[]{"org.apache.deltaspike"})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return jar;
    }

    @After
    public void stopContexts() {
        this.ctxCtrl.stopContexts();
    }

    @Test
    public void helloRequestScoped() {
        Assert.assertNotNull((Object)this.myRequestBean);
        this.ctxCtrl.startContext(RequestScoped.class);
        String myBeanId = this.myRequestBean.getMyBean().getId();
        long myKieSessionId = this.myRequestBean.getkSession().getIdentifier();
        int result = this.myRequestBean.doSomething("hello 0");
        Assert.assertEquals((long)1L, (long)result);
        this.ctxCtrl.stopContext(RequestScoped.class);
        this.ctxCtrl.startContext(RequestScoped.class);
        Assert.assertNotEquals((Object)myBeanId, (Object)this.myRequestBean.getMyBean().getId());
        Assert.assertNotEquals((long)myKieSessionId, (long)this.myRequestBean.getkSession().getIdentifier());
        myBeanId = this.myRequestBean.getMyBean().getId();
        myKieSessionId = this.myRequestBean.getkSession().getIdentifier();
        result = this.myRequestBean.doSomething("hello 1");
        Assert.assertEquals((long)1L, (long)result);
        this.ctxCtrl.stopContext(RequestScoped.class);
        this.ctxCtrl.startContext(RequestScoped.class);
        Assert.assertNotEquals((Object)myBeanId, (Object)this.myRequestBean.getMyBean().getId());
        Assert.assertNotEquals((long)myKieSessionId, (long)this.myRequestBean.getkSession().getIdentifier());
        result = this.myRequestBean.doSomething("hello 2");
        Assert.assertEquals((long)1L, (long)result);
        myBeanId = this.myRequestBean.getMyBean().getId();
        myKieSessionId = this.myRequestBean.getkSession().getIdentifier();
        this.ctxCtrl.stopContext(RequestScoped.class);
        this.ctxCtrl.startContext(RequestScoped.class);
        Assert.assertNotEquals((Object)myBeanId, (Object)this.myRequestBean.getMyBean().getId());
        Assert.assertNotEquals((long)myKieSessionId, (long)this.myRequestBean.getkSession().getIdentifier());
        this.ctxCtrl.stopContext(RequestScoped.class);
    }
}

