/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import org.drools.decisiontable.parser.xls.PropertiesSheetListener;
import org.junit.Assert;
import org.junit.Test;

public class PropertiesSheetListenerTest {
    @Test
    public void testProperties() {
        PropertiesSheetListener listener = new PropertiesSheetListener();
        listener.startSheet("test");
        listener.newRow(0, 4);
        listener.newCell(0, 0, "", -1);
        listener.newCell(0, 1, "key1", -1);
        listener.newCell(0, 2, "value1", -1);
        listener.newRow(1, 4);
        listener.newCell(1, 1, "key2", -1);
        listener.newCell(1, 3, "value2", -1);
        PropertiesSheetListener.CaseInsensitiveMap props = listener.getProperties();
        listener.newRow(2, 4);
        listener.newCell(1, 1, "key3", -1);
        Assert.assertEquals((Object)"value1", (Object)props.getSingleProperty("Key1"));
        Assert.assertEquals((Object)"value2", (Object)props.getSingleProperty("key2"));
    }

    @Test
    public void testCaseInsensitive() {
        PropertiesSheetListener.CaseInsensitiveMap map = new PropertiesSheetListener.CaseInsensitiveMap();
        map.addProperty("x3", new String[]{"hey", "B2"});
        map.addProperty("x4", new String[]{"wHee", "C3"});
        map.addProperty("XXx", new String[]{"hey2", "D4"});
        Assert.assertNull((Object)map.getProperty("x"));
        Assert.assertEquals((Object)"hey", (Object)map.getSingleProperty("x3"));
        Assert.assertEquals((Object)"hey", (Object)map.getSingleProperty("X3"));
        Assert.assertEquals((Object)"wHee", (Object)map.getSingleProperty("x4"));
        Assert.assertEquals((Object)"hey2", (Object)map.getSingleProperty("xxx"));
        Assert.assertEquals((Object)"hey2", (Object)map.getSingleProperty("XXX"));
        Assert.assertEquals((Object)"hey2", (Object)map.getSingleProperty("XXx"));
        Assert.assertEquals((Object)"Whee2", (Object)map.getSingleProperty("x", "Whee2"));
    }
}

