/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.pong;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import org.drools.games.GameConfiguration;
import org.drools.games.GameUI;
import org.drools.games.pong.Ball;
import org.drools.games.pong.Bat;
import org.drools.games.pong.Player;
import org.drools.games.pong.PongConfiguration;
import org.kie.api.runtime.KieSession;

public class PongUI
extends GameUI {
    private PongConfiguration pconf;

    public PongUI(KieSession ksession, GameConfiguration conf) {
        super(ksession, conf);
        this.pconf = (PongConfiguration)conf;
    }

    public void drawGame(Ball ball, Bat bat1, Bat bat2, Player p1, Player p2) {
        Graphics tableG = this.getGraphics();
        tableG.setColor(Color.BLACK);
        tableG.fillRect(0, 0, this.getWidth(), this.getHeight());
        tableG.setColor(Color.WHITE);
        this.drawScore(p1, 100);
        this.drawScore(p2, this.pconf.getTableWidth() - 120);
        this.drawTable();
        this.drawBall(ball);
        this.drawBat(bat1);
        this.drawBat(bat2);
        this.repaint();
    }

    public void drawTable() {
        Graphics tableG = this.getGraphics();
        int padding = this.pconf.getPadding();
        int tableWidth = this.pconf.getTableWidth();
        int tableHeight = this.pconf.getTableHeight();
        int sideLineWidth = this.pconf.getSideLineWidth();
        tableG.fillRect(padding, padding, tableWidth - padding * 2, sideLineWidth);
        tableG.fillRect(padding, tableHeight - padding - sideLineWidth, tableWidth - padding * 2, sideLineWidth);
        int netWidth = this.pconf.getNetWidth();
        int gap = this.pconf.getNetGap();
        int dash = this.pconf.getNetDash();
        int x = tableWidth / 2 - netWidth / 2;
        int i = 0;
        while (i < tableHeight) {
            tableG.fillRect(x, i, netWidth, dash);
            i = i + dash + gap;
        }
    }

    public void drawBall(Ball ball) {
        Graphics g = this.getGraphics();
        g.setColor(Color.WHITE);
        g.fillOval(ball.getX(), ball.getY(), ball.getWidth(), ball.getWidth());
    }

    public void drawBat(Bat bat) {
        Graphics g = this.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(bat.getX(), bat.getY(), bat.getWidth(), bat.getHeight());
    }

    public void drawScore(Player p, int x) {
        Graphics g = this.getGraphics();
        int y = this.pconf.boundedTop() + 60;
        g.setColor(Color.BLACK);
        g.fillRect(x, y - 60, 90, 90);
        FontRenderContext frc = ((Graphics2D)g).getFontRenderContext();
        Font f = new Font("Monospaced", 1, 70);
        String s = "" + p.getScore();
        TextLayout tl = new TextLayout(s, f, frc);
        g.setColor(Color.WHITE);
        tl.draw((Graphics2D)g, x, y);
    }
}

