/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.Optional;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScenarioTest {
    private ScesimModelDescriptor scesimModelDescriptor;
    private Scenario scenario;
    private FactIdentifier factIdentifier;
    private ExpressionIdentifier expressionIdentifier;
    private Simulation simulation;

    @Before
    public void init() {
        this.simulation = new Simulation();
        this.scesimModelDescriptor = this.simulation.getScesimModelDescriptor();
        this.scenario = (Scenario)this.simulation.addData();
        this.factIdentifier = FactIdentifier.create((String)"test fact", (String)String.class.getCanonicalName());
        this.expressionIdentifier = ExpressionIdentifier.create((String)"test expression", (FactMappingType)FactMappingType.EXPECT);
    }

    @Test
    public void removeFactMappingValueByIdentifiersTest() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertTrue((boolean)retrieved.isPresent());
        this.scenario.removeFactMappingValueByIdentifiers(this.factIdentifier, this.expressionIdentifier);
        retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void removeFactMappingValue() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        Optional retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertTrue((boolean)retrieved.isPresent());
        this.scenario.removeFactMappingValue((FactMappingValue)retrieved.get());
        retrieved = this.scenario.getFactMappingValue(this.factIdentifier, this.expressionIdentifier);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test(expected=IllegalArgumentException.class)
    public void addMappingValueTest() {
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
        this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)"test value");
    }

    @Test
    public void getDescriptionTest() {
        Assert.assertEquals((Object)"", (Object)this.scenario.getDescription());
        String description = "Test Description";
        this.scenario.addMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, (Object)description);
        Assert.assertEquals((Object)description, (Object)this.scenario.getDescription());
        Scenario scenarioWithDescriptionNull = (Scenario)this.simulation.addData();
        scenarioWithDescriptionNull.setDescription(null);
        Assert.assertEquals((Object)"", (Object)scenarioWithDescriptionNull.getDescription());
    }

    @Test
    public void addOrUpdateMappingValue() {
        String value1 = "Test 1";
        String value2 = "Test 2";
        FactMappingValue factMappingValue = this.scenario.addMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value1);
        Assert.assertEquals((Object)factMappingValue.getRawValue(), (Object)value1);
        FactMappingValue factMappingValue1 = this.scenario.addOrUpdateMappingValue(this.factIdentifier, this.expressionIdentifier, (Object)value2);
        Assert.assertEquals((Object)factMappingValue, (Object)factMappingValue1);
        Assert.assertEquals((Object)factMappingValue1.getRawValue(), (Object)value2);
    }
}

