/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.Arrays;
import java.util.function.Function;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.backend.fluent.ConditionFilter;
import org.drools.scenariosimulation.backend.fluent.FactCheckerHandle;
import org.drools.scenariosimulation.backend.runner.model.ResultWrapper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.junit.Assert;
import org.junit.Test;

public class ConditionFilterTest {
    @Test
    public void acceptTest() {
        Function<Object, ResultWrapper> alwaysMatchFunction = ResultWrapper::createResult;
        FactMappingValue factMappingValue = new FactMappingValue(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION, (Object)"Test");
        ScenarioResult scenarioResult = new ScenarioResult(FactIdentifier.DESCRIPTION, factMappingValue);
        ConditionFilter conditionFilter = new ConditionFilter(Arrays.asList(new FactCheckerHandle(String.class, alwaysMatchFunction, scenarioResult)));
        Assert.assertFalse((boolean)conditionFilter.accept((Object)1));
        Assert.assertTrue((boolean)conditionFilter.accept((Object)"String"));
        Function<Object, ResultWrapper> alwaysNotMatchFunction = object -> ResultWrapper.createErrorResult(null, null);
        ConditionFilter conditionFilterFail = new ConditionFilter(Arrays.asList(new FactCheckerHandle(String.class, alwaysNotMatchFunction, scenarioResult)));
        Assert.assertFalse((boolean)conditionFilterFail.accept((Object)"String"));
    }
}

