/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.List;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.scenariosimulation.backend.runner.SimulationRunMetadataBuilder;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.junit.Assert;
import org.junit.Test;

public class SimulationRunMetadataBuilderTest {
    @Test
    public void build() {
        ScenarioWithIndex scenarioWithIndex1 = new ScenarioWithIndex(1, new Scenario());
        ScenarioResultMetadata result1 = new ScenarioResultMetadata(scenarioWithIndex1);
        result1.addExecuted("d1");
        result1.addExecuted("d2");
        result1.addAvailable("d1");
        result1.addAvailable("d2");
        result1.addAvailable("d3");
        ScenarioResultMetadata result2 = new ScenarioResultMetadata(new ScenarioWithIndex(2, new Scenario()));
        result2.addExecuted("d1");
        result2.addExecuted("d3");
        result2.addAvailable("d1");
        result2.addAvailable("d2");
        result2.addAvailable("d3");
        SimulationRunMetadataBuilder builder = SimulationRunMetadataBuilder.create();
        builder.addScenarioResultMetadata(result1);
        builder.addScenarioResultMetadata(result2);
        SimulationRunMetadata build = builder.build();
        Assert.assertEquals((long)3L, (long)build.getAvailable());
        Assert.assertEquals((long)3L, (long)build.getExecuted());
        Assert.assertEquals((double)100.0, (double)build.getCoveragePercentage(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)((Integer)build.getOutputCounter().get("d1")).intValue(), (double)0.1);
        Assert.assertEquals((double)1.0, (double)((Integer)build.getOutputCounter().get("d2")).intValue(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)((List)build.getScenarioCounter().get(scenarioWithIndex1)).size(), (double)0.1);
    }
}

