/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.backend.TestUtils;
import org.drools.scenariosimulation.backend.util.InMemoryMigrationStrategy;
import org.drools.scenariosimulation.backend.util.MigrationStrategy;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationXMLPersistence;
import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.project.datamodel.imports.Import;

public class ScenarioSimulationXMLPersistenceTest {
    protected ScenarioSimulationXMLPersistence instance = ScenarioSimulationXMLPersistence.getInstance();
    protected String currentVersion = new ScenarioSimulationModel().getVersion();
    protected MigrationStrategy migrationInstance = new InMemoryMigrationStrategy();

    @Test
    public void noFQCNUsed() throws Exception {
        ScenarioSimulationModel simulationModel = new ScenarioSimulationModel();
        simulationModel.getImports().addImport(new Import("org.test.Test"));
        String xml = this.instance.marshal(simulationModel);
        Assert.assertFalse((boolean)xml.contains("org.drools.scenariosimulation.api.model"));
        Assert.assertFalse((boolean)xml.contains("org.kie.soup.project.datamodel.imports"));
    }

    @Test
    public void versionAttributeExists() throws Exception {
        String xml = this.instance.marshal(new ScenarioSimulationModel());
        Assert.assertTrue((boolean)xml.startsWith("<ScenarioSimulationModel version=\"" + ScenarioSimulationXMLPersistence.getCurrentVersion() + "\">"));
    }

    @Test
    public void migrateIfNecessary_1_0_to_1_1() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-0.scesim");
        String migrated = this.instance.migrateIfNecessary(toMigrate);
        Assert.assertTrue((boolean)toMigrate.contains("<ScenarioSimulationModel version=\"1.0\">"));
        Assert.assertFalse((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.0\">"));
        Assert.assertTrue((boolean)migrated.contains("EXPECT"));
        Assert.assertFalse((boolean)migrated.contains("EXPECTED"));
    }

    @Test
    public void migrateIfNecessary_1_1_to_1_2() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-1.scesim");
        String migrated = (String)this.migrationInstance.from1_1to1_2().apply(toMigrate);
        Assert.assertTrue((boolean)toMigrate.contains("<ScenarioSimulationModel version=\"1.1\">"));
        Assert.assertFalse((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.1\">"));
        Assert.assertTrue((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.2\">"));
        Assert.assertTrue((boolean)migrated.contains("dmoSession></dmoSession>"));
        Assert.assertTrue((boolean)migrated.contains("<type>RULE</type>"));
    }

    @Test
    public void migrateIfNecessary_1_2_to_1_3() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-2.scesim");
        String migrated = this.instance.migrateIfNecessary(toMigrate);
        Assert.assertTrue((boolean)toMigrate.contains("<ScenarioSimulationModel version=\"1.2\">"));
        Assert.assertFalse((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.2\">"));
        try {
            ScenarioSimulationModel unmarshalled = this.instance.unmarshal(migrated, false);
            for (FactMapping factMapping : unmarshalled.getSimulation().getSimulationDescriptor().getUnmodifiableFactMappings()) {
                Assert.assertTrue((factMapping.getExpressionElements().size() >= 1 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void migrateIfNecessary_1_3_to_1_4() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-3-rule.scesim");
        String migrated = (String)this.migrationInstance.from1_3to1_4().apply(toMigrate);
        Assert.assertTrue((boolean)toMigrate.contains("<ScenarioSimulationModel version=\"1.3\">"));
        Assert.assertFalse((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.3\">"));
        Assert.assertTrue((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.4\">"));
        Assert.assertTrue((boolean)migrated.contains("<fileName></fileName>"));
        Assert.assertTrue((boolean)migrated.contains("<kieSession>default</kieSession>"));
        Assert.assertTrue((boolean)migrated.contains("<kieBase>default</kieBase>"));
        Assert.assertTrue((boolean)migrated.contains("<ruleFlowGroup>default</ruleFlowGroup>"));
        Assert.assertTrue((boolean)migrated.contains("<dmoSession>default</dmoSession>"));
        Assert.assertTrue((boolean)migrated.contains("<skipFromBuild>false</skipFromBuild>"));
        Assert.assertTrue((boolean)migrated.contains("<type>RULE</type>"));
        try {
            this.instance.internalUnmarshal(migrated);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        toMigrate = TestUtils.getFileContent("scesim-1-3-dmn.scesim");
        migrated = (String)this.migrationInstance.from1_3to1_4().apply(toMigrate);
        Assert.assertTrue((boolean)toMigrate.contains("<ScenarioSimulationModel version=\"1.3\">"));
        Assert.assertFalse((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.3\">"));
        Assert.assertTrue((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.4\">"));
        Assert.assertTrue((boolean)migrated.contains("<dmnNamespace></dmnNamespace>"));
        Assert.assertTrue((boolean)migrated.contains("<dmnName></dmnName>"));
        Assert.assertTrue((boolean)migrated.contains("<skipFromBuild>false</skipFromBuild>"));
        Assert.assertTrue((boolean)migrated.contains("<type>DMN</type>"));
        try {
            this.instance.internalUnmarshal(migrated);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void migrateIfNecessary_1_4_to_1_5() throws Exception {
        String toMigrate = TestUtils.getFileContent("scesim-1-3-rule.scesim");
        Assert.assertTrue((boolean)toMigrate.contains("dmoSession"));
        String migrated = this.instance.migrateIfNecessary(toMigrate);
        Assert.assertFalse((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.3\">"));
        Assert.assertFalse((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.4\">"));
        Assert.assertTrue((boolean)migrated.contains("<ScenarioSimulationModel version=\"" + this.currentVersion + "\">"));
        Assert.assertTrue((!migrated.contains("dmoSession") ? 1 : 0) != 0);
    }

    @Test
    public void migrateIfNecessary() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instance.migrateIfNecessary("<ScenarioSimulationModel version=\"9999999999.99999999999\">")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Version 9999999999.99999999999 of the file is not supported. Current version is " + ScenarioSimulationXMLPersistence.getCurrentVersion());
        String noMigrationNeeded = "<ScenarioSimulationModel version=\"" + ScenarioSimulationXMLPersistence.getCurrentVersion() + "\">";
        String afterMigration = this.instance.migrateIfNecessary(noMigrationNeeded);
        Assert.assertEquals((Object)noMigrationNeeded, (Object)afterMigration);
    }

    @Test
    public void extractVersion() {
        String version = this.instance.extractVersion("<ScenarioSimulationModel version=\"1.0\" version=\"1.1\">");
        Assert.assertEquals((Object)"1.0", (Object)version);
    }

    @Test
    public void unmarshalRULE() throws Exception {
        String toUnmarshal = TestUtils.getFileContent("scesim-rule.scesim");
        ScenarioSimulationModel retrieved = ScenarioSimulationXMLPersistence.getInstance().unmarshal(toUnmarshal);
        Assert.assertEquals((Object)retrieved.getSimulation().getSimulationDescriptor().getType(), (Object)ScenarioSimulationModel.Type.RULE);
    }

    @Test
    public void unmarshalDMN() throws Exception {
        String toUnmarshal = TestUtils.getFileContent("scesim-dmn.scesim");
        ScenarioSimulationModel retrieved = ScenarioSimulationXMLPersistence.getInstance().unmarshal(toUnmarshal);
        Assert.assertEquals((Object)retrieved.getSimulation().getSimulationDescriptor().getType(), (Object)ScenarioSimulationModel.Type.DMN);
    }
}

