/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;

public class SimulationRunMetadataBuilder {
    protected List<ScenarioResultMetadata> scenarioResultMetadata = new ArrayList<ScenarioResultMetadata>();

    private SimulationRunMetadataBuilder() {
    }

    public SimulationRunMetadataBuilder addScenarioResultMetadata(ScenarioResultMetadata scenarioResultMetadata) {
        this.scenarioResultMetadata.add(scenarioResultMetadata);
        return this;
    }

    public SimulationRunMetadata build() {
        int available = 0;
        HashMap outputCounter = new HashMap();
        HashMap<ScenarioWithIndex, ArrayList<String>> scenarioCounter = new HashMap<ScenarioWithIndex, ArrayList<String>>();
        for (ScenarioResultMetadata scenarioResultMetadatum : this.scenarioResultMetadata) {
            available = scenarioResultMetadatum.getAvailable().size();
            scenarioResultMetadatum.getExecuted().forEach(name -> outputCounter.compute(name, (key, number) -> number == null ? 1 : number + 1));
        }
        for (ScenarioResultMetadata scenarioResultMetadatum : this.scenarioResultMetadata) {
            scenarioCounter.put(scenarioResultMetadatum.getScenarioWithIndex(), new ArrayList<String>(scenarioResultMetadatum.getExecuted()));
        }
        return new SimulationRunMetadata(available, outputCounter.keySet().size(), outputCounter, scenarioCounter);
    }

    public static SimulationRunMetadataBuilder create() {
        return new SimulationRunMetadataBuilder();
    }
}

