/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.backend.util.InMemoryMigrationStrategy;
import org.drools.scenariosimulation.backend.util.MigrationStrategy;
import org.kie.soup.commons.xstream.XStreamUtils;
import org.kie.soup.project.datamodel.imports.Import;

public class ScenarioSimulationXMLPersistence {
    private XStream xt;
    private static final ScenarioSimulationXMLPersistence INSTANCE = new ScenarioSimulationXMLPersistence();
    private static final String currentVersion = new ScenarioSimulationModel().getVersion();
    private static final Pattern p = Pattern.compile("version=\"([0-9]+\\.[0-9]+)");
    private MigrationStrategy migrationStrategy = new InMemoryMigrationStrategy();

    private ScenarioSimulationXMLPersistence() {
        this.xt = XStreamUtils.createTrustingXStream((HierarchicalStreamDriver)new DomDriver());
        this.xt.autodetectAnnotations(true);
        this.xt.alias("ExpressionElement", ExpressionElement.class);
        this.xt.alias("ExpressionIdentifier", ExpressionIdentifier.class);
        this.xt.alias("FactIdentifier", FactIdentifier.class);
        this.xt.alias("FactMapping", FactMapping.class);
        this.xt.alias("FactMappingType", FactMappingType.class);
        this.xt.alias("FactMappingValue", FactMappingValue.class);
        this.xt.alias("Scenario", Scenario.class);
        this.xt.alias("ScenarioSimulationModel", ScenarioSimulationModel.class);
        this.xt.alias("Simulation", Simulation.class);
        this.xt.alias("SimulationDescriptor", SimulationDescriptor.class);
        this.xt.alias("Import", Import.class);
    }

    public static ScenarioSimulationXMLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(ScenarioSimulationModel sc) {
        return this.xt.toXML((Object)sc);
    }

    public ScenarioSimulationModel unmarshal(String rawXml) {
        return this.unmarshal(rawXml, true);
    }

    public ScenarioSimulationModel unmarshal(String rawXml, boolean migrate) {
        if (rawXml == null) {
            return new ScenarioSimulationModel();
        }
        if (rawXml.trim().equals("")) {
            return new ScenarioSimulationModel();
        }
        String xml = migrate ? this.migrateIfNecessary(rawXml) : rawXml;
        return this.internalUnmarshal(xml);
    }

    public String migrateIfNecessary(String rawXml) {
        String fileVersion = this.extractVersion(rawXml);
        Function<String, String> migrator = this.getMigrationStrategy().start();
        boolean supported = currentVersion.equals(fileVersion);
        switch (fileVersion) {
            case "1.0": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_0to1_1());
            }
            case "1.1": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_1to1_2());
            }
            case "1.2": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_2to1_3());
            }
            case "1.3": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_3to1_4());
            }
            case "1.4": {
                migrator = migrator.andThen(this.getMigrationStrategy().from1_4to1_5());
                supported = true;
            }
        }
        if (!supported) {
            throw new IllegalArgumentException("Version " + fileVersion + " of the file is not supported. Current version is " + currentVersion);
        }
        migrator = migrator.andThen(this.getMigrationStrategy().end());
        return migrator.apply(rawXml);
    }

    public String extractVersion(String rawXml) {
        Matcher m = p.matcher(rawXml);
        if (m.find()) {
            return m.group(1);
        }
        throw new IllegalArgumentException("Impossible to extract version from the file");
    }

    public MigrationStrategy getMigrationStrategy() {
        return this.migrationStrategy;
    }

    public void setMigrationStrategy(MigrationStrategy migrationStrategy) {
        this.migrationStrategy = migrationStrategy;
    }

    public static String getCurrentVersion() {
        return currentVersion;
    }

    protected ScenarioSimulationModel internalUnmarshal(String xml) {
        Object o = this.xt.fromXML(xml);
        return (ScenarioSimulationModel)o;
    }
}

