/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.model.ResultWrapper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieContainer;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractRunnerHelperTest {
    AbstractRunnerHelper abstractRunnerHelper = new AbstractRunnerHelper(){

        protected ScenarioResultMetadata extractResultMetadata(Map<String, Object> requestContext, ScenarioWithIndex scenarioWithIndex) {
            return null;
        }

        protected Map<String, Object> executeScenario(KieContainer kieContainer, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, SimulationDescriptor simulationDescriptor) {
            return null;
        }

        protected void verifyConditions(SimulationDescriptor simulationDescriptor, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, Map<String, Object> requestContext) {
        }

        protected Object createObject(String className, Map<List<String>, Object> params, ClassLoader classLoader) {
            return null;
        }
    };

    @Test
    public void fillResult() {
        FactIdentifier factIdentifier = FactIdentifier.create((String)"MyInstance", (String)String.class.getCanonicalName());
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)"MyProperty", (FactMappingType)FactMappingType.GIVEN);
        FactMappingValue expectedResultSpy = (FactMappingValue)Mockito.spy((Object)new FactMappingValue(factIdentifier, expressionIdentifier, (Object)"value"));
        AtomicReference<ResultWrapper> resultWrapperAtomicReference = new AtomicReference<ResultWrapper>();
        Supplier<ResultWrapper> resultWrapperSupplier = resultWrapperAtomicReference::get;
        BaseExpressionEvaluator expressionEvaluator = new BaseExpressionEvaluator(AbstractRunnerHelper.class.getClassLoader());
        resultWrapperAtomicReference.set(ResultWrapper.createResult((Object)"value"));
        Assert.assertTrue((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, (ExpressionEvaluator)expressionEvaluator).getResult());
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).resetStatus();
        Mockito.reset((Object[])new FactMappingValue[]{expectedResultSpy});
        resultWrapperAtomicReference.set(ResultWrapper.createErrorResult((Object)"value", (Object)"value1"));
        Assert.assertFalse((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, (ExpressionEvaluator)expressionEvaluator).getResult());
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setErrorValue(Matchers.eq((Object)"value"));
        Mockito.reset((Object[])new FactMappingValue[]{expectedResultSpy});
        resultWrapperAtomicReference.set(ResultWrapper.createErrorResult((Object)"value", (Object)"value1"));
        ExpressionEvaluator expressionEvaluatorMock = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class);
        Mockito.when((Object)expressionEvaluatorMock.fromObjectToExpression(Matchers.any())).thenThrow(new Throwable[]{new IllegalArgumentException("Error")});
        Assert.assertFalse((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, expressionEvaluatorMock).getResult());
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setExceptionMessage((String)Matchers.eq((Object)"Error"));
        Mockito.reset((Object[])new FactMappingValue[]{expectedResultSpy});
        resultWrapperAtomicReference.set(ResultWrapper.createErrorResultWithErrorMessage((String)"detailedError"));
        Assert.assertFalse((boolean)this.abstractRunnerHelper.fillResult(expectedResultSpy, resultWrapperSupplier, (ExpressionEvaluator)expressionEvaluator).getResult());
        ((FactMappingValue)Mockito.verify((Object)expectedResultSpy, (VerificationMode)Mockito.times((int)1))).setExceptionMessage((String)Matchers.eq((Object)"detailedError"));
    }

    @Test
    public void getResultWrapper() {
        ExpressionEvaluator expressionEvaluatorMock = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class);
        String resultRaw = "test";
        String expectedResultRaw = "";
        String collectionError = "Impossible to find elements in the collection to satisfy the conditions";
        String genericErrorMessage = "errorMessage";
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression(Matchers.any(), Matchers.any(), (Class)Matchers.any(Class.class))).thenReturn((Object)true);
        ResultWrapper resultWrapper = this.abstractRunnerHelper.getResultWrapper(String.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, String.class);
        Assert.assertTrue((boolean)resultWrapper.isSatisfied());
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression(Matchers.any(), Matchers.any(), (Class)Matchers.any(Class.class))).thenReturn((Object)false);
        resultWrapper = this.abstractRunnerHelper.getResultWrapper(String.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, String.class);
        Assert.assertFalse((boolean)resultWrapper.isSatisfied());
        Assert.assertEquals((Object)resultRaw, (Object)resultWrapper.getResult());
        resultWrapper = this.abstractRunnerHelper.getResultWrapper(List.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, List.class);
        Assert.assertEquals((Object)collectionError, resultWrapper.getErrorMessage().get());
        resultWrapper = this.abstractRunnerHelper.getResultWrapper(Map.class.getCanonicalName(), new FactMappingValue(), expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, Map.class);
        Assert.assertEquals((Object)collectionError, resultWrapper.getErrorMessage().get());
        Mockito.when((Object)expressionEvaluatorMock.evaluateUnaryExpression(Matchers.any(), Matchers.any(), (Class)Matchers.any(Class.class))).thenThrow(new Throwable[]{new IllegalArgumentException(genericErrorMessage)});
        FactMappingValue expectedResult5 = new FactMappingValue();
        resultWrapper = this.abstractRunnerHelper.getResultWrapper(Map.class.getCanonicalName(), expectedResult5, expressionEvaluatorMock, (Object)expectedResultRaw, (Object)resultRaw, Map.class);
        Assert.assertEquals((Object)genericErrorMessage, resultWrapper.getErrorMessage().get());
        Assert.assertEquals((Object)genericErrorMessage, (Object)expectedResult5.getExceptionMessage());
    }
}

