/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.time.LocalDate;
import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.backend.expression.BaseExpressionOperator;
import org.junit.Assert;
import org.junit.Test;

public class BaseExpressionOperatorTest {
    private static final ClassLoader classLoader = BaseExpressionOperatorTest.class.getClassLoader();

    @Test
    public void evaluateLiteralExpression() {
        Arrays.stream(BaseExpressionOperator.values()).filter(e -> !BaseExpressionOperator.EQUALS.equals(e)).forEach(operator -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> operator.evaluateLiteralExpression(String.class.getCanonicalName(), " Test ", classLoader)).isInstanceOf(IllegalStateException.class)).hasMessageEndingWith(" operator cannot be used in a GIVEN clause"));
        Assert.assertEquals((Object)"Test", (Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(String.class.getCanonicalName(), "= Test", classLoader));
        Assert.assertEquals((Object)"", (Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(String.class.getCanonicalName(), "= ", classLoader));
        Assert.assertNull((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(String.class.getCanonicalName(), "null", classLoader));
        Assert.assertNull((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(String.class.getCanonicalName(), "= null", classLoader));
        Assert.assertNull((Object)BaseExpressionOperator.EQUALS.evaluateLiteralExpression(String.class.getCanonicalName(), null, classLoader));
    }

    @Test
    public void findOperator() {
        String rawValue = "Test";
        Assert.assertEquals((Object)BaseExpressionOperator.EQUALS, (Object)BaseExpressionOperator.findOperator((String)rawValue));
        rawValue = " Test ";
        Assert.assertEquals((Object)BaseExpressionOperator.EQUALS, (Object)BaseExpressionOperator.findOperator((String)rawValue));
        rawValue = "= Test ";
        Assert.assertEquals((Object)BaseExpressionOperator.EQUALS, (Object)BaseExpressionOperator.findOperator((String)rawValue));
        rawValue = "!= Test ";
        Assert.assertEquals((Object)BaseExpressionOperator.NOT_EQUALS, (Object)BaseExpressionOperator.findOperator((String)rawValue));
    }

    @Test
    public void equalsTest() {
        String test1 = "2019-12-02";
        LocalDate test2 = LocalDate.of(2019, 12, 2);
        Assert.assertTrue((boolean)BaseExpressionOperator.EQUALS.eval(test1, (Object)test2, test2.getClass(), classLoader));
        Assert.assertFalse((boolean)BaseExpressionOperator.EQUALS.eval(test1, (Object)test2.plusDays(1L), test2.getClass(), classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.EQUALS.eval("1", (Object)1, Integer.TYPE, classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.EQUALS.eval(null, null, null, classLoader));
    }

    @Test
    public void notEqualsTest() {
        String test1 = "2019-12-02";
        LocalDate test2 = LocalDate.of(2019, 12, 2);
        Assert.assertFalse((boolean)BaseExpressionOperator.NOT_EQUALS.eval(test1, (Object)test2, test2.getClass(), classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.NOT_EQUALS.eval(test1, (Object)test2.plusDays(1L), test2.getClass(), classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.NOT_EQUALS.eval("<> 1", (Object)2, Integer.TYPE, classLoader));
        Assert.assertFalse((boolean)BaseExpressionOperator.NOT_EQUALS.eval(null, null, null, classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.NOT_EQUALS.eval("! <1", (Object)2, Integer.TYPE, classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.NOT_EQUALS.eval("! [1, 3]", (Object)2, Integer.TYPE, classLoader));
    }

    @Test
    public void rangeTest() {
        Assert.assertFalse((boolean)BaseExpressionOperator.RANGE.eval("", (Object)"test", String.class, classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.RANGE.eval(">2", (Object)3, Integer.TYPE, classLoader));
    }

    @Test
    public void listOfValuesTest() {
        Assert.assertFalse((boolean)BaseExpressionOperator.LIST_OF_VALUES.eval("", (Object)"test", String.class, classLoader));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BaseExpressionOperator.LIST_OF_VALUES.eval("[ 2", (Object)"", String.class, classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Malformed expression: [ 2");
        Assert.assertTrue((boolean)BaseExpressionOperator.LIST_OF_VALUES.eval("[ Test, Another Test]", (Object)"Another Test", String.class, classLoader));
    }

    @Test
    public void listOfConditionsTest() {
        Assert.assertFalse((boolean)BaseExpressionOperator.LIST_OF_CONDITION.eval("", (Object)"test", String.class, classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.LIST_OF_CONDITION.eval("=1; ![2, 3]; <10", (Object)1, Integer.TYPE, classLoader));
        Assert.assertFalse((boolean)BaseExpressionOperator.LIST_OF_CONDITION.eval(null, (Object)1, Integer.TYPE, classLoader));
    }
}

