/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.RuleStatefulScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.RuleStatelessScenarioExecutableBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.internal.definition.rule.InternalRule;
import org.mockito.Mockito;

public class RuleScenarioExecutableBuilderTest {
    @Test
    public void createBuilder() {
        RuleScenarioExecutableBuilder builder = RuleScenarioExecutableBuilder.createBuilder(null, null, (boolean)true);
        Assert.assertTrue((boolean)(builder instanceof RuleStatelessScenarioExecutableBuilder));
        builder = RuleScenarioExecutableBuilder.createBuilder(null, null, (boolean)false);
        Assert.assertTrue((boolean)(builder instanceof RuleStatefulScenarioExecutableBuilder));
        builder = RuleScenarioExecutableBuilder.createBuilder(null);
        Assert.assertTrue((boolean)(builder instanceof RuleStatefulScenarioExecutableBuilder));
    }

    @Test
    public void getAvailableRules() {
        HashMap<String, List<String>> packagesToRules = new HashMap<String, List<String>>();
        packagesToRules.put("package1", Arrays.asList("rule1", "rule2", "rule3"));
        packagesToRules.put("package2", Arrays.asList("rule4", "rule5", "rule6"));
        HashMap<String, String> ruleToAgendaGroup = new HashMap<String, String>();
        ruleToAgendaGroup.put("rule1", "agenda1");
        ruleToAgendaGroup.put("rule2", "agenda1");
        ruleToAgendaGroup.put("rule3", "agenda1");
        ruleToAgendaGroup.put("rule4", "agenda2");
        RuleScenarioExecutableBuilder builder = RuleScenarioExecutableBuilder.createBuilder(null, null, (boolean)false);
        Set agenda1 = builder.getAvailableRules(this.createKieBaseMock(packagesToRules, ruleToAgendaGroup), "agenda1");
        Assert.assertEquals((long)5L, (long)agenda1.size());
        Set agenda2 = builder.getAvailableRules(this.createKieBaseMock(packagesToRules, ruleToAgendaGroup), "agenda2");
        Assert.assertEquals((long)3L, (long)agenda2.size());
        Set noAgenda = builder.getAvailableRules(this.createKieBaseMock(packagesToRules, ruleToAgendaGroup), null);
        Assert.assertEquals((long)2L, (long)noAgenda.size());
    }

    private KieBase createKieBaseMock(Map<String, List<String>> packagesToRules, Map<String, String> ruleToAgendaGroup) {
        KieBase kieBaseMock = (KieBase)Mockito.mock(KieBase.class);
        ArrayList<KiePackage> kiePackagesMock = new ArrayList<KiePackage>();
        Mockito.when((Object)kieBaseMock.getKiePackages()).thenReturn(kiePackagesMock);
        for (Map.Entry<String, List<String>> packageToRule : packagesToRules.entrySet()) {
            kiePackagesMock.add(this.createKiePackageMock(packageToRule.getKey(), packageToRule.getValue(), ruleToAgendaGroup));
        }
        return kieBaseMock;
    }

    private KiePackage createKiePackageMock(String packageName, List<String> ruleNames, Map<String, String> ruleToAgendaGroup) {
        KiePackage kiePackageMock = (KiePackage)Mockito.mock(KiePackage.class);
        Mockito.when((Object)kiePackageMock.getName()).thenReturn((Object)packageName);
        ArrayList<InternalRule> ruleListMock = new ArrayList<InternalRule>();
        Mockito.when((Object)kiePackageMock.getRules()).thenReturn(ruleListMock);
        for (String ruleName : ruleNames) {
            ruleListMock.add(this.createRuleMock(ruleName, ruleToAgendaGroup.get(ruleName)));
        }
        return kiePackageMock;
    }

    private InternalRule createRuleMock(String fullName, String agendaGroup) {
        InternalRule ruleMock = (InternalRule)Mockito.mock(InternalRule.class);
        Mockito.when((Object)ruleMock.getName()).thenReturn((Object)fullName);
        Mockito.when((Object)ruleMock.getPackageName()).thenReturn((Object)"");
        Mockito.when((Object)ruleMock.isMainAgendaGroup()).thenReturn((Object)(agendaGroup == null ? 1 : 0));
        Mockito.when((Object)ruleMock.getAgendaGroup()).thenReturn((Object)agendaGroup);
        return ruleMock;
    }
}

