/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.scenariosimulation.backend.util.ResourceHelper;
import org.junit.Assert;
import org.junit.Test;

public class ResourceHelperTest {
    @Test
    public void getClassPathElementsTest() {
        List<String> classPathElements = Arrays.asList(ResourceHelper.getClassPathElements());
        List notJar = classPathElements.stream().filter(elem -> !elem.contains(".jar")).collect(Collectors.toList());
        Assert.assertTrue((boolean)notJar.stream().anyMatch(elem -> elem.contains("test-classes")));
    }

    @Test
    public void getResourcesByExtensionTest() {
        Stream txtResources = ResourceHelper.getResourcesByExtension((String)"txt");
        List resources = txtResources.collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertTrue((boolean)resources.stream().anyMatch(elem -> elem.endsWith("testFile.txt")));
    }

    @Test
    public void getResourcesFromDirectoryTest() {
        List<String> classPathElements = Arrays.asList(ResourceHelper.getClassPathElements());
        Optional<String> testFolder = classPathElements.stream().filter(elem -> elem.contains("test-classes")).findFirst();
        Assert.assertTrue((boolean)testFolder.isPresent());
        File dir = new File(testFolder.get());
        List filesFound = ResourceHelper.getResourcesFromDirectory((File)dir, (Pattern)Pattern.compile(".*testFile.txt")).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)filesFound.size());
        Assert.assertEquals((long)0L, (long)ResourceHelper.getResourcesFromDirectory(null, null).count());
        Assert.assertEquals((long)0L, (long)ResourceHelper.getResourcesFromDirectory((File)dir, (Pattern)Pattern.compile("noMatch")).count());
    }

    @Test
    public void internalGetResourcesTest() {
        List<String> classPathElements = Arrays.asList(ResourceHelper.getClassPathElements());
        Optional<String> testFolder = classPathElements.stream().filter(elem -> elem.contains("test-classes")).findFirst();
        Assert.assertTrue((boolean)testFolder.isPresent());
        File dir = new File(testFolder.get());
        List filesFound = ResourceHelper.internalGetResources((String)testFolder.get(), (Pattern)Pattern.compile(".*\\.txt$")).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)filesFound.size());
        Assert.assertEquals((long)0L, (long)ResourceHelper.internalGetResources((String)((String)filesFound.get(0)), (Pattern)Pattern.compile(".*\\.txt$")).count());
    }
}

